// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure representing the postAgentProfileRequest.
 */
public class PostAgentProfileRequest private constructor(builder: Builder) {
    /**
     * The submitted profiling data.
     */
    public val agentProfile: kotlin.ByteArray = requireNotNull(builder.agentProfile) { "A non-null value must be provided for agentProfile" }
    /**
     * The format of the submitted profiling data. The format maps to the `Accept` and `Content-Type` headers of the HTTP request. You can specify one of the following: or the default .
     * + `application/json` — standard JSON format
     * + `application/x-amzn-ion` — the Amazon Ion data format. For more information, see [Amazon Ion](http://amzn.github.io/ion-docs/).
     */
    public val contentType: kotlin.String = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }
    /**
     * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries.
     */
    public val profileToken: kotlin.String? = builder.profileToken
    /**
     * The name of the profiling group with the aggregated profile that receives the submitted profiling data.
     */
    public val profilingGroupName: kotlin.String = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PostAgentProfileRequest(")
        append("agentProfile=$agentProfile,")
        append("contentType=$contentType,")
        append("profileToken=$profileToken,")
        append("profilingGroupName=$profilingGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = agentProfile.contentHashCode()
        result = 31 * result + (contentType.hashCode())
        result = 31 * result + (profileToken?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PostAgentProfileRequest

        if (!agentProfile.contentEquals(other.agentProfile)) return false
        if (contentType != other.contentType) return false
        if (profileToken != other.profileToken) return false
        if (profilingGroupName != other.profilingGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The submitted profiling data.
         */
        public var agentProfile: kotlin.ByteArray? = null
        /**
         * The format of the submitted profiling data. The format maps to the `Accept` and `Content-Type` headers of the HTTP request. You can specify one of the following: or the default .
         * + `application/json` — standard JSON format
         * + `application/x-amzn-ion` — the Amazon Ion data format. For more information, see [Amazon Ion](http://amzn.github.io/ion-docs/).
         */
        public var contentType: kotlin.String? = null
        /**
         * Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries.
         */
        public var profileToken: kotlin.String? = null
        /**
         * The name of the profiling group with the aggregated profile that receives the submitted profiling data.
         */
        public var profilingGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest) : this() {
            this.agentProfile = x.agentProfile
            this.contentType = x.contentType
            this.profileToken = x.profileToken
            this.profilingGroupName = x.profilingGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.PostAgentProfileRequest = PostAgentProfileRequest(this)

        internal fun correctErrors(): Builder {
            if (agentProfile == null) agentProfile = ByteArray(0)
            if (contentType == null) contentType = ""
            if (profilingGroupName == null) profilingGroupName = ""
            return this
        }
    }
}
