// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the GetRecommendationsResponse.
 */
public class GetRecommendationsResponse private constructor(builder: Builder) {
    /**
     * The list of anomalies that the analysis has found for this profile.
     */
    public val anomalies: List<Anomaly> = requireNotNull(builder.anomalies) { "A non-null value must be provided for anomalies" }
    /**
     * The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val profileEndTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.profileEndTime) { "A non-null value must be provided for profileEndTime" }
    /**
     * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val profileStartTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.profileStartTime) { "A non-null value must be provided for profileStartTime" }
    /**
     * The name of the profiling group the analysis data is about.
     */
    public val profilingGroupName: kotlin.String = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }
    /**
     * The list of recommendations that the analysis found for this profile.
     */
    public val recommendations: List<Recommendation> = requireNotNull(builder.recommendations) { "A non-null value must be provided for recommendations" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationsResponse(")
        append("anomalies=$anomalies,")
        append("profileEndTime=$profileEndTime,")
        append("profileStartTime=$profileStartTime,")
        append("profilingGroupName=$profilingGroupName,")
        append("recommendations=$recommendations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = anomalies.hashCode()
        result = 31 * result + (profileEndTime.hashCode())
        result = 31 * result + (profileStartTime.hashCode())
        result = 31 * result + (profilingGroupName.hashCode())
        result = 31 * result + (recommendations.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationsResponse

        if (anomalies != other.anomalies) return false
        if (profileEndTime != other.profileEndTime) return false
        if (profileStartTime != other.profileStartTime) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (recommendations != other.recommendations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of anomalies that the analysis has found for this profile.
         */
        public var anomalies: List<Anomaly>? = null
        /**
         * The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var profileEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var profileStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the profiling group the analysis data is about.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * The list of recommendations that the analysis found for this profile.
         */
        public var recommendations: List<Recommendation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse) : this() {
            this.anomalies = x.anomalies
            this.profileEndTime = x.profileEndTime
            this.profileStartTime = x.profileStartTime
            this.profilingGroupName = x.profilingGroupName
            this.recommendations = x.recommendations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsResponse = GetRecommendationsResponse(this)

        internal fun correctErrors(): Builder {
            if (anomalies == null) anomalies = emptyList()
            if (profileEndTime == null) profileEndTime = Instant.fromEpochSeconds(0)
            if (profileStartTime == null) profileStartTime = Instant.fromEpochSeconds(0)
            if (profilingGroupName == null) profilingGroupName = ""
            if (recommendations == null) recommendations = emptyList()
            return this
        }
    }
}
