// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The structure representing the GetRecommendationsRequest.
 */
public class GetRecommendationsRequest private constructor(builder: Builder) {
    /**
     * The start time of the profile to get analysis data about. You must specify `startTime` and `endTime`. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The language used to provide analysis. Specify using a string that is one of the following `BCP 47` language codes.
     * + `de-DE` - German, Germany
     * + `en-GB` - English, United Kingdom
     * + `en-US` - English, United States
     * + `es-ES` - Spanish, Spain
     * + `fr-FR` - French, France
     * + `it-IT` - Italian, Italy
     * + `ja-JP` - Japanese, Japan
     * + `ko-KR` - Korean, Republic of Korea
     * + `pt-BR` - Portugese, Brazil
     * + `zh-CN` - Chinese, China
     * + `zh-TW` - Chinese, Taiwan
     */
    public val locale: kotlin.String? = builder.locale
    /**
     * The name of the profiling group to get analysis data about.
     */
    public val profilingGroupName: kotlin.String = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }
    /**
     * The end time of the profile to get analysis data about. You must specify `startTime` and `endTime`. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRecommendationsRequest(")
        append("endTime=$endTime,")
        append("locale=$locale,")
        append("profilingGroupName=$profilingGroupName,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime.hashCode()
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName.hashCode())
        result = 31 * result + (startTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRecommendationsRequest

        if (endTime != other.endTime) return false
        if (locale != other.locale) return false
        if (profilingGroupName != other.profilingGroupName) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The start time of the profile to get analysis data about. You must specify `startTime` and `endTime`. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The language used to provide analysis. Specify using a string that is one of the following `BCP 47` language codes.
         * + `de-DE` - German, Germany
         * + `en-GB` - English, United Kingdom
         * + `en-US` - English, United States
         * + `es-ES` - Spanish, Spain
         * + `fr-FR` - French, France
         * + `it-IT` - Italian, Italy
         * + `ja-JP` - Japanese, Japan
         * + `ko-KR` - Korean, Republic of Korea
         * + `pt-BR` - Portugese, Brazil
         * + `zh-CN` - Chinese, China
         * + `zh-TW` - Chinese, Taiwan
         */
        public var locale: kotlin.String? = null
        /**
         * The name of the profiling group to get analysis data about.
         */
        public var profilingGroupName: kotlin.String? = null
        /**
         * The end time of the profile to get analysis data about. You must specify `startTime` and `endTime`. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest) : this() {
            this.endTime = x.endTime
            this.locale = x.locale
            this.profilingGroupName = x.profilingGroupName
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.GetRecommendationsRequest = GetRecommendationsRequest(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (profilingGroupName == null) profilingGroupName = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
