// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The structure representing the configureAgentRequest.
 */
public class ConfigureAgentRequest private constructor(builder: Builder) {
    /**
     * A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID.
     */
    public val fleetInstanceId: kotlin.String? = builder.fleetInstanceId
    /**
     * Metadata captured about the compute platform the agent is running on. It includes information about sampling and reporting. The valid fields are:
     * + `COMPUTE_PLATFORM` - The compute platform on which the agent is running
     * + `AGENT_ID` - The ID for an agent instance.
     * + `AWS_REQUEST_ID` - The AWS request ID of a Lambda invocation.
     * + `EXECUTION_ENVIRONMENT` - The execution environment a Lambda function is running on.
     * + `LAMBDA_FUNCTION_ARN` - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
     * + `LAMBDA_MEMORY_LIMIT_IN_MB` - The memory allocated to a Lambda function.
     * + `LAMBDA_REMAINING_TIME_IN_MILLISECONDS` - The time in milliseconds before execution of a Lambda function times out.
     * + `LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS` - The time in milliseconds between two invocations of a Lambda function.
     * + `LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS` - The time in milliseconds for the previous Lambda invocation.
     */
    public val metadata: Map<MetadataField, String>? = builder.metadata
    /**
     * The name of the profiling group for which the configured agent is collecting profiling data.
     */
    public val profilingGroupName: kotlin.String = requireNotNull(builder.profilingGroupName) { "A non-null value must be provided for profilingGroupName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConfigureAgentRequest(")
        append("fleetInstanceId=$fleetInstanceId,")
        append("metadata=$metadata,")
        append("profilingGroupName=$profilingGroupName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = fleetInstanceId?.hashCode() ?: 0
        result = 31 * result + (metadata?.hashCode() ?: 0)
        result = 31 * result + (profilingGroupName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConfigureAgentRequest

        if (fleetInstanceId != other.fleetInstanceId) return false
        if (metadata != other.metadata) return false
        if (profilingGroupName != other.profilingGroupName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container's task ID.
         */
        public var fleetInstanceId: kotlin.String? = null
        /**
         * Metadata captured about the compute platform the agent is running on. It includes information about sampling and reporting. The valid fields are:
         * + `COMPUTE_PLATFORM` - The compute platform on which the agent is running
         * + `AGENT_ID` - The ID for an agent instance.
         * + `AWS_REQUEST_ID` - The AWS request ID of a Lambda invocation.
         * + `EXECUTION_ENVIRONMENT` - The execution environment a Lambda function is running on.
         * + `LAMBDA_FUNCTION_ARN` - The Amazon Resource Name (ARN) that is used to invoke a Lambda function.
         * + `LAMBDA_MEMORY_LIMIT_IN_MB` - The memory allocated to a Lambda function.
         * + `LAMBDA_REMAINING_TIME_IN_MILLISECONDS` - The time in milliseconds before execution of a Lambda function times out.
         * + `LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS` - The time in milliseconds between two invocations of a Lambda function.
         * + `LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS` - The time in milliseconds for the previous Lambda invocation.
         */
        public var metadata: Map<MetadataField, String>? = null
        /**
         * The name of the profiling group for which the configured agent is collecting profiling data.
         */
        public var profilingGroupName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest) : this() {
            this.fleetInstanceId = x.fleetInstanceId
            this.metadata = x.metadata
            this.profilingGroupName = x.profilingGroupName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.ConfigureAgentRequest = ConfigureAgentRequest(this)

        internal fun correctErrors(): Builder {
            if (profilingGroupName == null) profilingGroupName = ""
            return this
        }
    }
}
