// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeguruprofiler.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The specific duration in which the metric is flagged as anomalous.
 */
public class AnomalyInstance private constructor(builder: Builder) {
    /**
     * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The start time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * Feedback type on a specific instance of anomaly submitted by the user.
     */
    public val userFeedback: aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback? = builder.userFeedback

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeguruprofiler.model.AnomalyInstance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnomalyInstance(")
        append("endTime=$endTime,")
        append("id=$id,")
        append("startTime=$startTime,")
        append("userFeedback=$userFeedback")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (userFeedback?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnomalyInstance

        if (endTime != other.endTime) return false
        if (id != other.id) return false
        if (startTime != other.startTime) return false
        if (userFeedback != other.userFeedback) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeguruprofiler.model.AnomalyInstance = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The universally unique identifier (UUID) of an instance of an anomaly in a metric.
         */
        public var id: kotlin.String? = null
        /**
         * The start time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Feedback type on a specific instance of anomaly submitted by the user.
         */
        public var userFeedback: aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeguruprofiler.model.AnomalyInstance) : this() {
            this.endTime = x.endTime
            this.id = x.id
            this.startTime = x.startTime
            this.userFeedback = x.userFeedback
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeguruprofiler.model.AnomalyInstance = AnomalyInstance(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback] inside the given [block]
         */
        public fun userFeedback(block: aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback.Builder.() -> kotlin.Unit) {
            this.userFeedback = aws.sdk.kotlin.services.codeguruprofiler.model.UserFeedback.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
