// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateDeploymentGroupOperationDeserializer: HttpDeserialize<UpdateDeploymentGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDeploymentGroupResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentGroupError(context, response)
        }
        val builder = UpdateDeploymentGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDeploymentGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateDeploymentGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentGroupAlreadyExistsException" -> DeploymentGroupAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "ECSServiceMappingLimitExceededException" -> EcsServiceMappingLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidBlueGreenDeploymentConfigurationException" -> InvalidBlueGreenDeploymentConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentStyleException" -> InvalidDeploymentStyleExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEC2TagCombinationException" -> InvalidEc2TagCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidEC2TagException" -> InvalidEc2TagExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidECSServiceException" -> InvalidEcsServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOnPremisesTagCombinationException" -> InvalidOnPremisesTagCombinationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTargetGroupPairException" -> InvalidTargetGroupPairExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTriggerConfigException" -> InvalidTriggerConfigExceptionDeserializer().deserialize(context, wrappedResponse)
        "LifecycleHookLimitExceededException" -> LifecycleHookLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "TagSetListLimitExceededException" -> TagSetListLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "TriggerTargetsLimitExceededException" -> TriggerTargetsLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentGroupOperationBody(builder: UpdateDeploymentGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOOKSNOTCLEANEDUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hooksNotCleanedUp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOOKSNOTCLEANEDUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOOKSNOTCLEANEDUP_DESCRIPTOR.index -> builder.hooksNotCleanedUp =
                    deserializer.deserializeList(HOOKSNOTCLEANEDUP_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoScalingGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoScalingGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
