// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a deployment lifecycle event.
 */
class LifecycleEvent private constructor(builder: Builder) {
    /**
     * Diagnostic information about the deployment lifecycle event.
     */
    val diagnostics: aws.sdk.kotlin.services.codedeploy.model.Diagnostics? = builder.diagnostics
    /**
     * A timestamp that indicates when the deployment lifecycle event ended.
     */
    val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The deployment lifecycle event name, such as `ApplicationStop`, `BeforeInstall`, `AfterInstall`, `ApplicationStart`, or `ValidateService`.
     */
    val lifecycleEventName: kotlin.String? = builder.lifecycleEventName
    /**
     * A timestamp that indicates when the deployment lifecycle event started.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The deployment lifecycle event status:
     * + Pending: The deployment lifecycle event is pending.
     * + InProgress: The deployment lifecycle event is in progress.
     * + Succeeded: The deployment lifecycle event ran successfully.
     * + Failed: The deployment lifecycle event has failed.
     * + Skipped: The deployment lifecycle event has been skipped.
     * + Unknown: The deployment lifecycle event is unknown.
     */
    val status: aws.sdk.kotlin.services.codedeploy.model.LifecycleEventStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.LifecycleEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LifecycleEvent(")
        append("diagnostics=$diagnostics,")
        append("endTime=$endTime,")
        append("lifecycleEventName=$lifecycleEventName,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = diagnostics?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEventName?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LifecycleEvent

        if (diagnostics != other.diagnostics) return false
        if (endTime != other.endTime) return false
        if (lifecycleEventName != other.lifecycleEventName) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.LifecycleEvent = Builder(this).apply(block).build()

    class Builder {
        /**
         * Diagnostic information about the deployment lifecycle event.
         */
        var diagnostics: aws.sdk.kotlin.services.codedeploy.model.Diagnostics? = null
        /**
         * A timestamp that indicates when the deployment lifecycle event ended.
         */
        var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment lifecycle event name, such as `ApplicationStop`, `BeforeInstall`, `AfterInstall`, `ApplicationStart`, or `ValidateService`.
         */
        var lifecycleEventName: kotlin.String? = null
        /**
         * A timestamp that indicates when the deployment lifecycle event started.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The deployment lifecycle event status:
         * + Pending: The deployment lifecycle event is pending.
         * + InProgress: The deployment lifecycle event is in progress.
         * + Succeeded: The deployment lifecycle event ran successfully.
         * + Failed: The deployment lifecycle event has failed.
         * + Skipped: The deployment lifecycle event has been skipped.
         * + Unknown: The deployment lifecycle event is unknown.
         */
        var status: aws.sdk.kotlin.services.codedeploy.model.LifecycleEventStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.LifecycleEvent) : this() {
            this.diagnostics = x.diagnostics
            this.endTime = x.endTime
            this.lifecycleEventName = x.lifecycleEventName
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.LifecycleEvent = LifecycleEvent(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Diagnostics] inside the given [block]
         */
        fun diagnostics(block: aws.sdk.kotlin.services.codedeploy.model.Diagnostics.Builder.() -> kotlin.Unit) {
            this.diagnostics = aws.sdk.kotlin.services.codedeploy.model.Diagnostics.invoke(block)
        }
    }
}
