// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateDeploymentGroupOperationDeserializer: HttpDeserializer.NonStreaming<UpdateDeploymentGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateDeploymentGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentGroupError(context, call, payload)
        }
        val builder = UpdateDeploymentGroupResponse.Builder()

        if (payload != null) {
            deserializeUpdateDeploymentGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateDeploymentGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentStyleException" -> InvalidDeploymentStyleExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidECSServiceException" -> InvalidEcsServiceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupAlreadyExistsException" -> DeploymentGroupAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEC2TagException" -> InvalidEc2TagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTargetGroupPairException" -> InvalidTargetGroupPairExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TriggerTargetsLimitExceededException" -> TriggerTargetsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEC2TagCombinationException" -> InvalidEc2TagCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTriggerConfigException" -> InvalidTriggerConfigExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ECSServiceMappingLimitExceededException" -> EcsServiceMappingLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidBlueGreenDeploymentConfigurationException" -> InvalidBlueGreenDeploymentConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidOnPremisesTagCombinationException" -> InvalidOnPremisesTagCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagSetListLimitExceededException" -> TagSetListLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LifecycleHookLimitExceededException" -> LifecycleHookLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentGroupOperationBody(builder: UpdateDeploymentGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOOKSNOTCLEANEDUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hooksNotCleanedUp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOOKSNOTCLEANEDUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOOKSNOTCLEANEDUP_DESCRIPTOR.index -> builder.hooksNotCleanedUp =
                    deserializer.deserializeList(HOOKSNOTCLEANEDUP_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoScalingGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoScalingGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
