// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeploymentGroupInfo
import aws.sdk.kotlin.services.codedeploy.model.GetDeploymentGroupResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetDeploymentGroupOperationDeserializer: HttpDeserializer.NonStreaming<GetDeploymentGroupResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetDeploymentGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetDeploymentGroupError(context, call, payload)
        }
        val builder = GetDeploymentGroupResponse.Builder()

        if (payload != null) {
            deserializeGetDeploymentGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetDeploymentGroupError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDeploymentGroupOperationBody(builder: GetDeploymentGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTGROUPINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentGroupInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTGROUPINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTGROUPINFO_DESCRIPTOR.index -> builder.deploymentGroupInfo = deserializeDeploymentGroupInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
