// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.GenericRevisionInfo
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationRevisionResponse
import aws.sdk.kotlin.services.codedeploy.model.RevisionLocation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetApplicationRevisionOperationDeserializer: HttpDeserializer.NonStreaming<GetApplicationRevisionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetApplicationRevisionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetApplicationRevisionError(context, call, payload)
        }
        val builder = GetApplicationRevisionResponse.Builder()

        if (payload != null) {
            deserializeGetApplicationRevisionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetApplicationRevisionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionDoesNotExistException" -> RevisionDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetApplicationRevisionOperationBody(builder: GetApplicationRevisionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationName"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revision"))
    val REVISIONINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revisionInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONNAME_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
        field(REVISIONINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeRevisionLocationDocument(deserializer)
                REVISIONINFO_DESCRIPTOR.index -> builder.revisionInfo = deserializeGenericRevisionInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
