// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<CreateDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDeploymentError(context, call, payload)
        }
        val builder = CreateDeploymentResponse.Builder()

        if (payload != null) {
            deserializeCreateDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidIgnoreApplicationStopFailuresValueException" -> InvalidIgnoreApplicationStopFailuresValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFileExistsBehaviorException" -> InvalidFileExistsBehaviorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTargetInstancesException" -> InvalidTargetInstancesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentLimitExceededException" -> DeploymentLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidUpdateOutdatedInstancesOnlyValueException" -> InvalidUpdateOutdatedInstancesOnlyValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DescriptionTooLongException" -> DescriptionTooLongExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGitHubAccountTokenException" -> InvalidGitHubAccountTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RevisionDoesNotExistException" -> RevisionDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDeploymentOperationBody(builder: CreateDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
