// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeploymentConfigOperationDeserializer: HttpDeserializer.NonStreaming<CreateDeploymentConfigResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateDeploymentConfigResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDeploymentConfigError(context, call, payload)
        }
        val builder = CreateDeploymentConfigResponse.Builder()

        if (payload != null) {
            deserializeCreateDeploymentConfigOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateDeploymentConfigError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidZonalDeploymentConfigurationException" -> InvalidZonalDeploymentConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigNameRequiredException" -> DeploymentConfigNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidComputePlatformException" -> InvalidComputePlatformExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigAlreadyExistsException" -> DeploymentConfigAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentConfigLimitExceededException" -> DeploymentConfigLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMinimumHealthyHostValueException" -> InvalidMinimumHealthyHostValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDeploymentConfigOperationBody(builder: CreateDeploymentConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTCONFIGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentConfigId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTCONFIGID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTCONFIGID_DESCRIPTOR.index -> builder.deploymentConfigId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
