// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.ContinueDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class ContinueDeploymentOperationDeserializer: HttpDeserializer.NonStreaming<ContinueDeploymentResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ContinueDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwContinueDeploymentError(context, call, payload)
        }
        val builder = ContinueDeploymentResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwContinueDeploymentError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentAlreadyCompletedException" -> DeploymentAlreadyCompletedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentIsNotInReadyStateException" -> DeploymentIsNotInReadyStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentWaitTypeException" -> InvalidDeploymentWaitTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedActionForDeploymentTypeException" -> UnsupportedActionForDeploymentTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentStatusException" -> InvalidDeploymentStatusExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
