// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentTargetsResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetDeploymentTargetsOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetDeploymentTargetsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetDeploymentTargetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetDeploymentTargetsError(context, call, payload)
        }
        val builder = BatchGetDeploymentTargetsResponse.Builder()

        if (payload != null) {
            deserializeBatchGetDeploymentTargetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetDeploymentTargetsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentTargetIdRequiredException" -> DeploymentTargetIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentNotStartedException" -> DeploymentNotStartedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceDoesNotExistException" -> InstanceDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentTargetIdException" -> InvalidDeploymentTargetIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentTargetDoesNotExistException" -> DeploymentTargetDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentTargetListSizeExceededException" -> DeploymentTargetListSizeExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetDeploymentTargetsOperationBody(builder: BatchGetDeploymentTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deploymentTargets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTTARGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTTARGETS_DESCRIPTOR.index -> builder.deploymentTargets =
                    deserializer.deserializeList(DEPLOYMENTTARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentTarget>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentTargetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
