// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.InstanceSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetDeploymentInstancesOperationDeserializer: HttpDeserializer.NonStreaming<BatchGetDeploymentInstancesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchGetDeploymentInstancesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetDeploymentInstancesError(context, call, payload)
        }
        val builder = BatchGetDeploymentInstancesResponse.Builder()

        if (payload != null) {
            deserializeBatchGetDeploymentInstancesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchGetDeploymentInstancesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BatchLimitExceededException" -> BatchLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceIdRequiredException" -> InstanceIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidComputePlatformException" -> InvalidComputePlatformExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceNameException" -> InvalidInstanceNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetDeploymentInstancesOperationBody(builder: BatchGetDeploymentInstancesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val INSTANCESSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("instancesSummary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORMESSAGE_DESCRIPTOR)
        field(INSTANCESSUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                INSTANCESSUMMARY_DESCRIPTOR.index -> builder.instancesSummary =
                    deserializer.deserializeList(INSTANCESSUMMARY_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
