// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.AddTagsToOnPremisesInstancesResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AddTagsToOnPremisesInstancesOperationDeserializer: HttpDeserializer.NonStreaming<AddTagsToOnPremisesInstancesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddTagsToOnPremisesInstancesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddTagsToOnPremisesInstancesError(context, call, payload)
        }
        val builder = AddTagsToOnPremisesInstancesResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddTagsToOnPremisesInstancesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "TagLimitExceededException" -> TagLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceNameRequiredException" -> InstanceNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceLimitExceededException" -> InstanceLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TagRequiredException" -> TagRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceNameException" -> InvalidInstanceNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InstanceNotRegisteredException" -> InstanceNotRegisteredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
