// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configure the `ZonalConfig` object if you want CodeDeploy to deploy your application to one [Availability Zone](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones) at a time, within an Amazon Web Services Region. By deploying to one Availability Zone at a time, you can expose your deployment to a progressively larger audience as confidence in the deployment's performance and viability grows. If you don't configure the `ZonalConfig` object, CodeDeploy deploys your application to a random selection of hosts across a Region.
 *
 * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
 */
public class ZonalConfig private constructor(builder: Builder) {
    /**
     * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the *first* Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the second Availability Zone. You might set this option if you want to allow extra bake time for the first Availability Zone. If you don't specify a value for `firstZoneMonitorDurationInSeconds`, then CodeDeploy uses the `monitorDurationInSeconds` value for the first Availability Zone.
     *
     * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
     */
    public val firstZoneMonitorDurationInSeconds: kotlin.Long? = builder.firstZoneMonitorDurationInSeconds
    /**
     * The number or percentage of instances that must remain available per Availability Zone during a deployment. This option works in conjunction with the `MinimumHealthyHosts` option. For more information, see [About the minimum number of healthy hosts per Availability Zone](https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az) in the *CodeDeploy User Guide*.
     *
     * If you don't specify the `minimumHealthyHostsPerZone` option, then CodeDeploy uses a default value of `0` percent.
     *
     * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
     */
    public val minimumHealthyHostsPerZone: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsPerZone? = builder.minimumHealthyHostsPerZone
    /**
     * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the next Availability Zone. Consider adding a monitor duration to give the deployment some time to prove itself (or 'bake') in one Availability Zone before it is released in the next zone. If you don't specify a `monitorDurationInSeconds`, CodeDeploy starts deploying to the next Availability Zone immediately.
     *
     * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
     */
    public val monitorDurationInSeconds: kotlin.Long? = builder.monitorDurationInSeconds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ZonalConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ZonalConfig(")
        append("firstZoneMonitorDurationInSeconds=$firstZoneMonitorDurationInSeconds,")
        append("minimumHealthyHostsPerZone=$minimumHealthyHostsPerZone,")
        append("monitorDurationInSeconds=$monitorDurationInSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = firstZoneMonitorDurationInSeconds?.hashCode() ?: 0
        result = 31 * result + (minimumHealthyHostsPerZone?.hashCode() ?: 0)
        result = 31 * result + (monitorDurationInSeconds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ZonalConfig

        if (firstZoneMonitorDurationInSeconds != other.firstZoneMonitorDurationInSeconds) return false
        if (minimumHealthyHostsPerZone != other.minimumHealthyHostsPerZone) return false
        if (monitorDurationInSeconds != other.monitorDurationInSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ZonalConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to the *first* Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the second Availability Zone. You might set this option if you want to allow extra bake time for the first Availability Zone. If you don't specify a value for `firstZoneMonitorDurationInSeconds`, then CodeDeploy uses the `monitorDurationInSeconds` value for the first Availability Zone.
         *
         * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
         */
        public var firstZoneMonitorDurationInSeconds: kotlin.Long? = null
        /**
         * The number or percentage of instances that must remain available per Availability Zone during a deployment. This option works in conjunction with the `MinimumHealthyHosts` option. For more information, see [About the minimum number of healthy hosts per Availability Zone](https://docs.aws.amazon.com/codedeploy/latest/userguide/instances-health.html#minimum-healthy-hosts-az) in the *CodeDeploy User Guide*.
         *
         * If you don't specify the `minimumHealthyHostsPerZone` option, then CodeDeploy uses a default value of `0` percent.
         *
         * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
         */
        public var minimumHealthyHostsPerZone: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsPerZone? = null
        /**
         * The period of time, in seconds, that CodeDeploy must wait after completing a deployment to an Availability Zone. CodeDeploy will wait this amount of time before starting a deployment to the next Availability Zone. Consider adding a monitor duration to give the deployment some time to prove itself (or 'bake') in one Availability Zone before it is released in the next zone. If you don't specify a `monitorDurationInSeconds`, CodeDeploy starts deploying to the next Availability Zone immediately.
         *
         * For more information about the zonal configuration feature, see [zonal configuration](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations-create.html#zonal-config) in the *CodeDeploy User Guide*.
         */
        public var monitorDurationInSeconds: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ZonalConfig) : this() {
            this.firstZoneMonitorDurationInSeconds = x.firstZoneMonitorDurationInSeconds
            this.minimumHealthyHostsPerZone = x.minimumHealthyHostsPerZone
            this.monitorDurationInSeconds = x.monitorDurationInSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ZonalConfig = ZonalConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsPerZone] inside the given [block]
         */
        public fun minimumHealthyHostsPerZone(block: aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsPerZone.Builder.() -> kotlin.Unit) {
            this.minimumHealthyHostsPerZone = aws.sdk.kotlin.services.codedeploy.model.MinimumHealthyHostsPerZone.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
