// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the Elastic Load Balancing load balancer or target group used in a deployment.
 *
 * You can use load balancers and target groups in combination. For example, if you have two Classic Load Balancers, and five target groups tied to an Application Load Balancer, you can specify the two Classic Load Balancers in `elbInfoList`, and the five target groups in `targetGroupInfoList`.
 */
public class LoadBalancerInfo private constructor(builder: Builder) {
    /**
     * An array that contains information about the load balancers to use for load balancing in a deployment. If you're using Classic Load Balancers, specify those load balancers in this array.
     *
     * You can add up to 10 load balancers to the array.
     *
     * If you're using Application Load Balancers or Network Load Balancers, use the `targetGroupInfoList` array instead of this one.
     */
    public val elbInfoList: List<ElbInfo>? = builder.elbInfoList
    /**
     * An array that contains information about the target groups to use for load balancing in a deployment. If you're using Application Load Balancers and Network Load Balancers, specify their associated target groups in this array.
     *
     * You can add up to 10 target groups to the array.
     *
     * If you're using Classic Load Balancers, use the `elbInfoList` array instead of this one.
     */
    public val targetGroupInfoList: List<TargetGroupInfo>? = builder.targetGroupInfoList
    /**
     * The target group pair information. This is an array of `TargeGroupPairInfo` objects with a maximum size of one.
     */
    public val targetGroupPairInfoList: List<TargetGroupPairInfo>? = builder.targetGroupPairInfoList

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerInfo(")
        append("elbInfoList=$elbInfoList,")
        append("targetGroupInfoList=$targetGroupInfoList,")
        append("targetGroupPairInfoList=$targetGroupPairInfoList")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = elbInfoList?.hashCode() ?: 0
        result = 31 * result + (targetGroupInfoList?.hashCode() ?: 0)
        result = 31 * result + (targetGroupPairInfoList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerInfo

        if (elbInfoList != other.elbInfoList) return false
        if (targetGroupInfoList != other.targetGroupInfoList) return false
        if (targetGroupPairInfoList != other.targetGroupPairInfoList) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array that contains information about the load balancers to use for load balancing in a deployment. If you're using Classic Load Balancers, specify those load balancers in this array.
         *
         * You can add up to 10 load balancers to the array.
         *
         * If you're using Application Load Balancers or Network Load Balancers, use the `targetGroupInfoList` array instead of this one.
         */
        public var elbInfoList: List<ElbInfo>? = null
        /**
         * An array that contains information about the target groups to use for load balancing in a deployment. If you're using Application Load Balancers and Network Load Balancers, specify their associated target groups in this array.
         *
         * You can add up to 10 target groups to the array.
         *
         * If you're using Classic Load Balancers, use the `elbInfoList` array instead of this one.
         */
        public var targetGroupInfoList: List<TargetGroupInfo>? = null
        /**
         * The target group pair information. This is an array of `TargeGroupPairInfo` objects with a maximum size of one.
         */
        public var targetGroupPairInfoList: List<TargetGroupPairInfo>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo) : this() {
            this.elbInfoList = x.elbInfoList
            this.targetGroupInfoList = x.targetGroupInfoList
            this.targetGroupPairInfoList = x.targetGroupPairInfoList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo = LoadBalancerInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
