// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a deployment error.
 */
public class ErrorInformation private constructor(builder: Builder) {
    /**
     * For more information, see [Error Codes for CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html) in the [CodeDeploy User Guide](https://docs.aws.amazon.com/codedeploy/latest/userguide).
     *
     * The error code:
     * + APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.
     * + DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.
     * + HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.
     * + HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.
     * + IAM_ROLE_MISSING: The service role cannot be accessed.
     * + IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
     * + INTERNAL_ERROR: There was an internal error.
     * + NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
     * + NO_INSTANCES: No instances were specified, or no instances can be found.
     * + OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
     * + THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more Amazon Web Services services.
     * + TIMEOUT: The deployment has timed out.
     * + REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.
     */
    public val code: aws.sdk.kotlin.services.codedeploy.model.ErrorCode? = builder.code
    /**
     * An accompanying error message.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ErrorInformation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ErrorInformation(")
        append("code=$code,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ErrorInformation

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ErrorInformation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * For more information, see [Error Codes for CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/error-codes.html) in the [CodeDeploy User Guide](https://docs.aws.amazon.com/codedeploy/latest/userguide).
         *
         * The error code:
         * + APPLICATION_MISSING: The application was missing. This error code is most likely raised if the application is deleted after the deployment is created, but before it is started.
         * + DEPLOYMENT_GROUP_MISSING: The deployment group was missing. This error code is most likely raised if the deployment group is deleted after the deployment is created, but before it is started.
         * + HEALTH_CONSTRAINTS: The deployment failed on too many instances to be successfully deployed within the instance health constraints specified.
         * + HEALTH_CONSTRAINTS_INVALID: The revision cannot be successfully deployed within the instance health constraints specified.
         * + IAM_ROLE_MISSING: The service role cannot be accessed.
         * + IAM_ROLE_PERMISSIONS: The service role does not have the correct permissions.
         * + INTERNAL_ERROR: There was an internal error.
         * + NO_EC2_SUBSCRIPTION: The calling account is not subscribed to Amazon EC2.
         * + NO_INSTANCES: No instances were specified, or no instances can be found.
         * + OVER_MAX_INSTANCES: The maximum number of instances was exceeded.
         * + THROTTLED: The operation was throttled because the calling account exceeded the throttling limits of one or more Amazon Web Services services.
         * + TIMEOUT: The deployment has timed out.
         * + REVISION_MISSING: The revision ID was missing. This error code is most likely raised if the revision is deleted after the deployment is created, but before it is started.
         */
        public var code: aws.sdk.kotlin.services.codedeploy.model.ErrorCode? = null
        /**
         * An accompanying error message.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ErrorInformation) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ErrorInformation = ErrorInformation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
