// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateDeploymentGroupOperationDeserializer: HttpDeserialize<UpdateDeploymentGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateDeploymentGroupResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateDeploymentGroupError(context, call)
        }
        val builder = UpdateDeploymentGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDeploymentGroupOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateDeploymentGroupError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDeploymentStyleException" -> InvalidDeploymentStyleExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidECSServiceException" -> InvalidEcsServiceExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer().deserialize(context, wrappedCall)
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentGroupAlreadyExistsException" -> DeploymentGroupAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTagException" -> InvalidTagExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEC2TagException" -> InvalidEc2TagExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTargetGroupPairException" -> InvalidTargetGroupPairExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedCall)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer().deserialize(context, wrappedCall)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall)
        "TriggerTargetsLimitExceededException" -> TriggerTargetsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidEC2TagCombinationException" -> InvalidEc2TagCombinationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTriggerConfigException" -> InvalidTriggerConfigExceptionDeserializer().deserialize(context, wrappedCall)
        "ECSServiceMappingLimitExceededException" -> EcsServiceMappingLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidBlueGreenDeploymentConfigurationException" -> InvalidBlueGreenDeploymentConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidOnPremisesTagCombinationException" -> InvalidOnPremisesTagCombinationExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "TagSetListLimitExceededException" -> TagSetListLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "LifecycleHookLimitExceededException" -> LifecycleHookLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDeploymentGroupOperationBody(builder: UpdateDeploymentGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOOKSNOTCLEANEDUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("hooksNotCleanedUp"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOOKSNOTCLEANEDUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOOKSNOTCLEANEDUP_DESCRIPTOR.index -> builder.hooksNotCleanedUp =
                    deserializer.deserializeList(HOOKSNOTCLEANEDUP_DESCRIPTOR) {
                        val col0 = mutableListOf<AutoScalingGroup>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAutoScalingGroupDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
