// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.ListDeploymentTargetsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListDeploymentTargetsOperationDeserializer: HttpDeserialize<ListDeploymentTargetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListDeploymentTargetsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListDeploymentTargetsError(context, call)
        }
        val builder = ListDeploymentTargetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListDeploymentTargetsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListDeploymentTargetsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTargetFilterNameException" -> InvalidTargetFilterNameExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentNotStartedException" -> DeploymentNotStartedExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDeploymentInstanceTypeException" -> InvalidDeploymentInstanceTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInstanceTypeException" -> InvalidInstanceTypeExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidInstanceStatusException" -> InvalidInstanceStatusExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListDeploymentTargetsOperationBody(builder: ListDeploymentTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val TARGETIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("targetIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(TARGETIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TARGETIDS_DESCRIPTOR.index -> builder.targetIds =
                    deserializer.deserializeList(TARGETIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
