// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.GenericRevisionInfo
import aws.sdk.kotlin.services.codedeploy.model.GetApplicationRevisionResponse
import aws.sdk.kotlin.services.codedeploy.model.RevisionLocation
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetApplicationRevisionOperationDeserializer: HttpDeserialize<GetApplicationRevisionResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetApplicationRevisionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetApplicationRevisionError(context, call)
        }
        val builder = GetApplicationRevisionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetApplicationRevisionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetApplicationRevisionError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionDoesNotExistException" -> RevisionDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer().deserialize(context, wrappedCall)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetApplicationRevisionOperationBody(builder: GetApplicationRevisionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationName"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revision"))
    val REVISIONINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("revisionInfo"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONNAME_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
        field(REVISIONINFO_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeRevisionLocationDocument(deserializer)
                REVISIONINFO_DESCRIPTOR.index -> builder.revisionInfo = deserializeGenericRevisionInfoDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
