// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.serde

import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateDeploymentOperationDeserializer: HttpDeserialize<CreateDeploymentResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateDeploymentResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateDeploymentError(context, call)
        }
        val builder = CreateDeploymentResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateDeploymentOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateDeploymentError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAutoScalingGroupException" -> InvalidAutoScalingGroupExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTrafficRoutingConfigurationException" -> InvalidTrafficRoutingConfigurationExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAlarmConfigException" -> InvalidAlarmConfigExceptionDeserializer().deserialize(context, wrappedCall)
        "AlarmsLimitExceededException" -> AlarmsLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidIgnoreApplicationStopFailuresValueException" -> InvalidIgnoreApplicationStopFailuresValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRoleException" -> InvalidRoleExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentGroupDoesNotExistException" -> DeploymentGroupDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidDeploymentGroupNameException" -> InvalidDeploymentGroupNameExceptionDeserializer().deserialize(context, wrappedCall)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidFileExistsBehaviorException" -> InvalidFileExistsBehaviorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidAutoRollbackConfigException" -> InvalidAutoRollbackConfigExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidTargetInstancesException" -> InvalidTargetInstancesExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentLimitExceededException" -> DeploymentLimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidUpdateOutdatedInstancesOnlyValueException" -> InvalidUpdateOutdatedInstancesOnlyValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionRequiredException" -> RevisionRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidLoadBalancerInfoException" -> InvalidLoadBalancerInfoExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidRevisionException" -> InvalidRevisionExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentConfigDoesNotExistException" -> DeploymentConfigDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        "DescriptionTooLongException" -> DescriptionTooLongExceptionDeserializer().deserialize(context, wrappedCall)
        "DeploymentGroupNameRequiredException" -> DeploymentGroupNameRequiredExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidGitHubAccountTokenException" -> InvalidGitHubAccountTokenExceptionDeserializer().deserialize(context, wrappedCall)
        "RevisionDoesNotExistException" -> RevisionDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateDeploymentOperationBody(builder: CreateDeploymentResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("deploymentId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTID_DESCRIPTOR.index -> builder.deploymentId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
