// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of an `UpdateDeploymentGroup` operation.
 */
public class UpdateDeploymentGroupRequest private constructor(builder: Builder) {
    /**
     * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The application name that corresponds to the deployment group to update.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Information for an automatic rollback configuration that is added or changed when a deployment group is updated.
     */
    public val autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.
     * + To keep the Auto Scaling groups, enter their names or do not specify this parameter.
     * + To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see [Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error "Heartbeat Timeout"](https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat) in the *CodeDeploy User Guide*.
     */
    public val autoScalingGroups: List<String>? = builder.autoScalingGroups
    /**
     * Information about blue/green deployment options for a deployment group.
     */
    public val blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = builder.blueGreenDeploymentConfiguration
    /**
     * The current name of the deployment group.
     */
    public val currentDeploymentGroupName: kotlin.String? = builder.currentDeploymentGroupName
    /**
     * The replacement deployment configuration name to use, if you want to change it.
     */
    public val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.
     */
    public val deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = builder.deploymentStyle
    /**
     * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public val ec2TagFilters: List<Ec2TagFilter>? = builder.ec2TagFilters
    /**
     * Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups.
     */
    public val ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = builder.ec2TagSet
    /**
     * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format `<clustername>:<servicename>`.
     */
    public val ecsServices: List<EcsService>? = builder.ecsServices
    /**
     * Information about the load balancer used in a deployment.
     */
    public val loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = builder.loadBalancerInfo
    /**
     * The new name of the deployment group, if you want to change it.
     */
    public val newDeploymentGroupName: kotlin.String? = builder.newDeploymentGroupName
    /**
     * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.
     */
    public val onPremisesInstanceTagFilters: List<TagFilter>? = builder.onPremisesInstanceTagFilters
    /**
     * Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.
     */
    public val onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = builder.onPremisesTagSet
    /**
     * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
     *
     * If this option is set to `UPDATE` or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
     *
     * If this option is set to `IGNORE`, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
     */
    public val outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = builder.outdatedInstancesStrategy
    /**
     * A replacement ARN for the service role, if you want to change it.
     */
    public val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information, see [Integrating CodeDeploy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html) in the *CodeDeploy User Guide*.
     *
     * Set `terminationHookEnabled` to `true` to have CodeDeploy install a termination hook into your Auto Scaling group when you update a deployment group. When this hook is installed, CodeDeploy will perform termination deployments.
     *
     * For information about termination deployments, see [Enabling termination deployments during Auto Scaling scale-in events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable) in the *CodeDeploy User Guide*.
     *
     * For more information about Auto Scaling scale-in events, see the [Scale in](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in) topic in the *Amazon EC2 Auto Scaling User Guide*.
     */
    public val terminationHookEnabled: kotlin.Boolean? = builder.terminationHookEnabled
    /**
     * Information about triggers to change when the deployment group is updated. For examples, see [Edit a Trigger in a CodeDeploy Deployment Group](https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html) in the *CodeDeploy User Guide*.
     */
    public val triggerConfigurations: List<TriggerConfig>? = builder.triggerConfigurations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDeploymentGroupRequest(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("autoScalingGroups=$autoScalingGroups,")
        append("blueGreenDeploymentConfiguration=$blueGreenDeploymentConfiguration,")
        append("currentDeploymentGroupName=$currentDeploymentGroupName,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentStyle=$deploymentStyle,")
        append("ec2TagFilters=$ec2TagFilters,")
        append("ec2TagSet=$ec2TagSet,")
        append("ecsServices=$ecsServices,")
        append("loadBalancerInfo=$loadBalancerInfo,")
        append("newDeploymentGroupName=$newDeploymentGroupName,")
        append("onPremisesInstanceTagFilters=$onPremisesInstanceTagFilters,")
        append("onPremisesTagSet=$onPremisesTagSet,")
        append("outdatedInstancesStrategy=$outdatedInstancesStrategy,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("terminationHookEnabled=$terminationHookEnabled,")
        append("triggerConfigurations=$triggerConfigurations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (applicationName?.hashCode() ?: 0)
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (autoScalingGroups?.hashCode() ?: 0)
        result = 31 * result + (blueGreenDeploymentConfiguration?.hashCode() ?: 0)
        result = 31 * result + (currentDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentStyle?.hashCode() ?: 0)
        result = 31 * result + (ec2TagFilters?.hashCode() ?: 0)
        result = 31 * result + (ec2TagSet?.hashCode() ?: 0)
        result = 31 * result + (ecsServices?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerInfo?.hashCode() ?: 0)
        result = 31 * result + (newDeploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (onPremisesInstanceTagFilters?.hashCode() ?: 0)
        result = 31 * result + (onPremisesTagSet?.hashCode() ?: 0)
        result = 31 * result + (outdatedInstancesStrategy?.hashCode() ?: 0)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (terminationHookEnabled?.hashCode() ?: 0)
        result = 31 * result + (triggerConfigurations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDeploymentGroupRequest

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (autoScalingGroups != other.autoScalingGroups) return false
        if (blueGreenDeploymentConfiguration != other.blueGreenDeploymentConfiguration) return false
        if (currentDeploymentGroupName != other.currentDeploymentGroupName) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentStyle != other.deploymentStyle) return false
        if (ec2TagFilters != other.ec2TagFilters) return false
        if (ec2TagSet != other.ec2TagSet) return false
        if (ecsServices != other.ecsServices) return false
        if (loadBalancerInfo != other.loadBalancerInfo) return false
        if (newDeploymentGroupName != other.newDeploymentGroupName) return false
        if (onPremisesInstanceTagFilters != other.onPremisesInstanceTagFilters) return false
        if (onPremisesTagSet != other.onPremisesTagSet) return false
        if (outdatedInstancesStrategy != other.outdatedInstancesStrategy) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (terminationHookEnabled != other.terminationHookEnabled) return false
        if (triggerConfigurations != other.triggerConfigurations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information to add or change about Amazon CloudWatch alarms when the deployment group is updated.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = null
        /**
         * The application name that corresponds to the deployment group to update.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Information for an automatic rollback configuration that is added or changed when a deployment group is updated.
         */
        public var autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = null
        /**
         * The replacement list of Auto Scaling groups to be included in the deployment group, if you want to change them.
         * + To keep the Auto Scaling groups, enter their names or do not specify this parameter.
         * + To remove Auto Scaling groups, specify a non-null empty list of Auto Scaling group names to detach all CodeDeploy-managed Auto Scaling lifecycle hooks. For examples, see [Amazon EC2 instances in an Amazon EC2 Auto Scaling group fail to launch and receive the error "Heartbeat Timeout"](https://docs.aws.amazon.com/codedeploy/latest/userguide/troubleshooting-auto-scaling.html#troubleshooting-auto-scaling-heartbeat) in the *CodeDeploy User Guide*.
         */
        public var autoScalingGroups: List<String>? = null
        /**
         * Information about blue/green deployment options for a deployment group.
         */
        public var blueGreenDeploymentConfiguration: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration? = null
        /**
         * The current name of the deployment group.
         */
        public var currentDeploymentGroupName: kotlin.String? = null
        /**
         * The replacement deployment configuration name to use, if you want to change it.
         */
        public var deploymentConfigName: kotlin.String? = null
        /**
         * Information about the type of deployment, either in-place or blue/green, you want to run and whether to route deployment traffic behind a load balancer.
         */
        public var deploymentStyle: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle? = null
        /**
         * The replacement set of Amazon EC2 tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         */
        public var ec2TagFilters: List<Ec2TagFilter>? = null
        /**
         * Information about groups of tags applied to on-premises instances. The deployment group includes only Amazon EC2 instances identified by all the tag groups.
         */
        public var ec2TagSet: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet? = null
        /**
         * The target Amazon ECS services in the deployment group. This applies only to deployment groups that use the Amazon ECS compute platform. A target Amazon ECS service is specified as an Amazon ECS cluster and service name pair using the format `<clustername>:<servicename>`.
         */
        public var ecsServices: List<EcsService>? = null
        /**
         * Information about the load balancer used in a deployment.
         */
        public var loadBalancerInfo: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo? = null
        /**
         * The new name of the deployment group, if you want to change it.
         */
        public var newDeploymentGroupName: kotlin.String? = null
        /**
         * The replacement set of on-premises instance tags on which to filter, if you want to change them. To keep the existing tags, enter their names. To remove tags, do not enter any tag names.
         */
        public var onPremisesInstanceTagFilters: List<TagFilter>? = null
        /**
         * Information about an on-premises instance tag set. The deployment group includes only on-premises instances identified by all the tag groups.
         */
        public var onPremisesTagSet: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet? = null
        /**
         * Indicates what happens when new Amazon EC2 instances are launched mid-deployment and do not receive the deployed application revision.
         *
         * If this option is set to `UPDATE` or is unspecified, CodeDeploy initiates one or more 'auto-update outdated instances' deployments to apply the deployed application revision to the new Amazon EC2 instances.
         *
         * If this option is set to `IGNORE`, CodeDeploy does not initiate a deployment to update the new Amazon EC2 instances. This may result in instances having different revisions.
         */
        public var outdatedInstancesStrategy: aws.sdk.kotlin.services.codedeploy.model.OutdatedInstancesStrategy? = null
        /**
         * A replacement ARN for the service role, if you want to change it.
         */
        public var serviceRoleArn: kotlin.String? = null
        /**
         * This parameter only applies if you are using CodeDeploy with Amazon EC2 Auto Scaling. For more information, see [Integrating CodeDeploy with Amazon EC2 Auto Scaling](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html) in the *CodeDeploy User Guide*.
         *
         * Set `terminationHookEnabled` to `true` to have CodeDeploy install a termination hook into your Auto Scaling group when you update a deployment group. When this hook is installed, CodeDeploy will perform termination deployments.
         *
         * For information about termination deployments, see [Enabling termination deployments during Auto Scaling scale-in events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable) in the *CodeDeploy User Guide*.
         *
         * For more information about Auto Scaling scale-in events, see the [Scale in](https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-lifecycle.html#as-lifecycle-scale-in) topic in the *Amazon EC2 Auto Scaling User Guide*.
         */
        public var terminationHookEnabled: kotlin.Boolean? = null
        /**
         * Information about triggers to change when the deployment group is updated. For examples, see [Edit a Trigger in a CodeDeploy Deployment Group](https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html) in the *CodeDeploy User Guide*.
         */
        public var triggerConfigurations: List<TriggerConfig>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.autoScalingGroups = x.autoScalingGroups
            this.blueGreenDeploymentConfiguration = x.blueGreenDeploymentConfiguration
            this.currentDeploymentGroupName = x.currentDeploymentGroupName
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentStyle = x.deploymentStyle
            this.ec2TagFilters = x.ec2TagFilters
            this.ec2TagSet = x.ec2TagSet
            this.ecsServices = x.ecsServices
            this.loadBalancerInfo = x.loadBalancerInfo
            this.newDeploymentGroupName = x.newDeploymentGroupName
            this.onPremisesInstanceTagFilters = x.onPremisesInstanceTagFilters
            this.onPremisesTagSet = x.onPremisesTagSet
            this.outdatedInstancesStrategy = x.outdatedInstancesStrategy
            this.serviceRoleArn = x.serviceRoleArn
            this.terminationHookEnabled = x.terminationHookEnabled
            this.triggerConfigurations = x.triggerConfigurations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.UpdateDeploymentGroupRequest = UpdateDeploymentGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        public fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration] inside the given [block]
         */
        public fun blueGreenDeploymentConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.Builder.() -> kotlin.Unit) {
            this.blueGreenDeploymentConfiguration = aws.sdk.kotlin.services.codedeploy.model.BlueGreenDeploymentConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle] inside the given [block]
         */
        public fun deploymentStyle(block: aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.Builder.() -> kotlin.Unit) {
            this.deploymentStyle = aws.sdk.kotlin.services.codedeploy.model.DeploymentStyle.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet] inside the given [block]
         */
        public fun ec2TagSet(block: aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.Builder.() -> kotlin.Unit) {
            this.ec2TagSet = aws.sdk.kotlin.services.codedeploy.model.Ec2TagSet.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo] inside the given [block]
         */
        public fun loadBalancerInfo(block: aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.Builder.() -> kotlin.Unit) {
            this.loadBalancerInfo = aws.sdk.kotlin.services.codedeploy.model.LoadBalancerInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet] inside the given [block]
         */
        public fun onPremisesTagSet(block: aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.Builder.() -> kotlin.Unit) {
            this.onPremisesTagSet = aws.sdk.kotlin.services.codedeploy.model.OnPremisesTagSet.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
