// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * The configuration that specifies how traffic is shifted from one version of a Lambda function to another version during an Lambda deployment, or from one Amazon ECS task set to another during an Amazon ECS deployment.
 */
public class TrafficRoutingConfig private constructor(builder: Builder) {
    /**
     * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
     */
    public val timeBasedCanary: aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary? = builder.timeBasedCanary
    /**
     * A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment's AppSpec file.
     */
    public val timeBasedLinear: aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear? = builder.timeBasedLinear
    /**
     * The type of traffic shifting (`TimeBasedCanary` or `TimeBasedLinear`) used by a deployment configuration.
     */
    public val type: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrafficRoutingConfig(")
        append("timeBasedCanary=$timeBasedCanary,")
        append("timeBasedLinear=$timeBasedLinear,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = timeBasedCanary?.hashCode() ?: 0
        result = 31 * result + (timeBasedLinear?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrafficRoutingConfig

        if (timeBasedCanary != other.timeBasedCanary) return false
        if (timeBasedLinear != other.timeBasedLinear) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A configuration that shifts traffic from one version of a Lambda function or ECS task set to another in two increments. The original and target Lambda function versions or ECS task sets are specified in the deployment's AppSpec file.
         */
        public var timeBasedCanary: aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary? = null
        /**
         * A configuration that shifts traffic from one version of a Lambda function or Amazon ECS task set to another in equal increments, with an equal number of minutes between each increment. The original and target Lambda function versions or Amazon ECS task sets are specified in the deployment's AppSpec file.
         */
        public var timeBasedLinear: aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear? = null
        /**
         * The type of traffic shifting (`TimeBasedCanary` or `TimeBasedLinear`) used by a deployment configuration.
         */
        public var type: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig) : this() {
            this.timeBasedCanary = x.timeBasedCanary
            this.timeBasedLinear = x.timeBasedLinear
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.TrafficRoutingConfig = TrafficRoutingConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary] inside the given [block]
         */
        public fun timeBasedCanary(block: aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary.Builder.() -> kotlin.Unit) {
            this.timeBasedCanary = aws.sdk.kotlin.services.codedeploy.model.TimeBasedCanary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear] inside the given [block]
         */
        public fun timeBasedLinear(block: aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear.Builder.() -> kotlin.Unit) {
            this.timeBasedLinear = aws.sdk.kotlin.services.codedeploy.model.TimeBasedLinear.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
