// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the target to be updated by an CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.
 */
public class CloudFormationTarget private constructor(builder: Builder) {
    /**
     * The unique ID of an CloudFormation blue/green deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The date and time when the target application was updated by an CloudFormation blue/green deployment.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the CloudFormation blue/green deployment to this target application.
     */
    public val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The resource type for the CloudFormation blue/green deployment.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * The status of an CloudFormation blue/green deployment's target application.
     */
    public val status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = builder.status
    /**
     * The unique ID of a deployment target that has a type of `CloudFormationTarget`.
     */
    public val targetId: kotlin.String? = builder.targetId
    /**
     * The percentage of production traffic that the target version of an CloudFormation blue/green deployment receives.
     */
    public val targetVersionWeight: kotlin.Double = builder.targetVersionWeight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CloudFormationTarget(")
        append("deploymentId=$deploymentId,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("resourceType=$resourceType,")
        append("status=$status,")
        append("targetId=$targetId,")
        append("targetVersionWeight=$targetVersionWeight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        result = 31 * result + (targetVersionWeight.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CloudFormationTarget

        if (deploymentId != other.deploymentId) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (resourceType != other.resourceType) return false
        if (status != other.status) return false
        if (targetId != other.targetId) return false
        if (targetVersionWeight != other.targetVersionWeight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of an CloudFormation blue/green deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The date and time when the target application was updated by an CloudFormation blue/green deployment.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle events of the CloudFormation blue/green deployment to this target application.
         */
        public var lifecycleEvents: List<LifecycleEvent>? = null
        /**
         * The resource type for the CloudFormation blue/green deployment.
         */
        public var resourceType: kotlin.String? = null
        /**
         * The status of an CloudFormation blue/green deployment's target application.
         */
        public var status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = null
        /**
         * The unique ID of a deployment target that has a type of `CloudFormationTarget`.
         */
        public var targetId: kotlin.String? = null
        /**
         * The percentage of production traffic that the target version of an CloudFormation blue/green deployment receives.
         */
        public var targetVersionWeight: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget) : this() {
            this.deploymentId = x.deploymentId
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.resourceType = x.resourceType
            this.status = x.status
            this.targetId = x.targetId
            this.targetVersionWeight = x.targetVersionWeight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget = CloudFormationTarget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
