// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about an Auto Scaling group.
 */
public class AutoScalingGroup private constructor(builder: Builder) {
    /**
     * The name of the launch hook that CodeDeploy installed into the Auto Scaling group.
     *
     * For more information about the launch hook, see [How Amazon EC2 Auto Scaling works with CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors) in the *CodeDeploy User Guide*.
     */
    public val hook: kotlin.String? = builder.hook
    /**
     * The Auto Scaling group name.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The name of the termination hook that CodeDeploy installed into the Auto Scaling group.
     *
     * For more information about the termination hook, see [Enabling termination deployments during Auto Scaling scale-in events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable) in the *CodeDeploy User Guide*.
     */
    public val terminationHook: kotlin.String? = builder.terminationHook

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingGroup(")
        append("hook=$hook,")
        append("name=$name,")
        append("terminationHook=$terminationHook")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hook?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (terminationHook?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingGroup

        if (hook != other.hook) return false
        if (name != other.name) return false
        if (terminationHook != other.terminationHook) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the launch hook that CodeDeploy installed into the Auto Scaling group.
         *
         * For more information about the launch hook, see [How Amazon EC2 Auto Scaling works with CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors) in the *CodeDeploy User Guide*.
         */
        public var hook: kotlin.String? = null
        /**
         * The Auto Scaling group name.
         */
        public var name: kotlin.String? = null
        /**
         * The name of the termination hook that CodeDeploy installed into the Auto Scaling group.
         *
         * For more information about the termination hook, see [Enabling termination deployments during Auto Scaling scale-in events](https://docs.aws.amazon.com/codedeploy/latest/userguide/integrations-aws-auto-scaling.html#integrations-aws-auto-scaling-behaviors-hook-enable) in the *CodeDeploy User Guide*.
         */
        public var terminationHook: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup) : this() {
            this.hook = x.hook
            this.name = x.name
            this.terminationHook = x.terminationHook
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.AutoScalingGroup = AutoScalingGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
