// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsResponse
import aws.sdk.kotlin.services.codedeploy.model.RevisionLocation
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListApplicationRevisionsOperationDeserializer: HttpDeserialize<ListApplicationRevisionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListApplicationRevisionsResponse {
        if (!response.status.isSuccess()) {
            throwListApplicationRevisionsError(context, response)
        }
        val builder = ListApplicationRevisionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListApplicationRevisionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListApplicationRevisionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ApplicationDoesNotExistException" -> ApplicationDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "ApplicationNameRequiredException" -> ApplicationNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "BucketNameFilterRequiredException" -> BucketNameFilterRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidApplicationNameException" -> InvalidApplicationNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidBucketNameFilterException" -> InvalidBucketNameFilterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeployedStateFilterException" -> InvalidDeployedStateFilterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyPrefixFilterException" -> InvalidKeyPrefixFilterExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSortByException" -> InvalidSortByExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSortOrderException" -> InvalidSortOrderExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListApplicationRevisionsOperationBody(builder: ListApplicationRevisionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val REVISIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("revisions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(REVISIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                REVISIONS_DESCRIPTOR.index -> builder.revisions =
                    deserializer.deserializeList(REVISIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RevisionLocation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRevisionLocationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
