// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeleteDeploymentConfigResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteDeploymentConfigOperationDeserializer: HttpDeserialize<DeleteDeploymentConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteDeploymentConfigResponse {
        if (!response.status.isSuccess()) {
            throwDeleteDeploymentConfigError(context, response)
        }
        val builder = DeleteDeploymentConfigResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteDeploymentConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentConfigInUseException" -> DeploymentConfigInUseExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentConfigNameRequiredException" -> DeploymentConfigNameRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentConfigNameException" -> InvalidDeploymentConfigNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidOperationException" -> InvalidOperationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
