// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.BatchGetDeploymentTargetsResponse
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetDeploymentTargetsOperationDeserializer: HttpDeserialize<BatchGetDeploymentTargetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetDeploymentTargetsResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetDeploymentTargetsError(context, response)
        }
        val builder = BatchGetDeploymentTargetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetDeploymentTargetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetDeploymentTargetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentNotStartedException" -> DeploymentNotStartedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentTargetDoesNotExistException" -> DeploymentTargetDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentTargetIdRequiredException" -> DeploymentTargetIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentTargetListSizeExceededException" -> DeploymentTargetListSizeExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InstanceDoesNotExistException" -> InstanceDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentTargetIdException" -> InvalidDeploymentTargetIdExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetDeploymentTargetsOperationBody(builder: BatchGetDeploymentTargetsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEPLOYMENTTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deploymentTargets"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTTARGETS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEPLOYMENTTARGETS_DESCRIPTOR.index -> builder.deploymentTargets =
                    deserializer.deserializeList(DEPLOYMENTTARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentTarget>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentTargetDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
