// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about two target groups and how traffic is routed during an Amazon ECS deployment. An optional test traffic route can be specified.
 */
public class TargetGroupPairInfo private constructor(builder: Builder) {
    /**
     * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
     */
    public val prodTrafficRoute: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute? = builder.prodTrafficRoute
    /**
     * One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete.
     */
    public val targetGroups: List<TargetGroupInfo>? = builder.targetGroups
    /**
     * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment.
     */
    public val testTrafficRoute: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute? = builder.testTrafficRoute

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.TargetGroupPairInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetGroupPairInfo(")
        append("prodTrafficRoute=$prodTrafficRoute,")
        append("targetGroups=$targetGroups,")
        append("testTrafficRoute=$testTrafficRoute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = prodTrafficRoute?.hashCode() ?: 0
        result = 31 * result + (targetGroups?.hashCode() ?: 0)
        result = 31 * result + (testTrafficRoute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetGroupPairInfo

        if (prodTrafficRoute != other.prodTrafficRoute) return false
        if (targetGroups != other.targetGroups) return false
        if (testTrafficRoute != other.testTrafficRoute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.TargetGroupPairInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path used by a load balancer to route production traffic when an Amazon ECS deployment is complete.
         */
        public var prodTrafficRoute: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute? = null
        /**
         * One pair of target groups. One is associated with the original task set. The second is associated with the task set that serves traffic after the deployment is complete.
         */
        public var targetGroups: List<TargetGroupInfo>? = null
        /**
         * An optional path used by a load balancer to route test traffic after an Amazon ECS deployment. Validation can occur while test traffic is served during a deployment.
         */
        public var testTrafficRoute: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.TargetGroupPairInfo) : this() {
            this.prodTrafficRoute = x.prodTrafficRoute
            this.targetGroups = x.targetGroups
            this.testTrafficRoute = x.testTrafficRoute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.TargetGroupPairInfo = TargetGroupPairInfo(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoute] inside the given [block]
         */
        public fun prodTrafficRoute(block: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute.Builder.() -> kotlin.Unit) {
            this.prodTrafficRoute = aws.sdk.kotlin.services.codedeploy.model.TrafficRoute.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TrafficRoute] inside the given [block]
         */
        public fun testTrafficRoute(block: aws.sdk.kotlin.services.codedeploy.model.TrafficRoute.Builder.() -> kotlin.Unit) {
            this.testTrafficRoute = aws.sdk.kotlin.services.codedeploy.model.TrafficRoute.invoke(block)
        }
    }
}
