// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `ListDeploymentInstances` operation.
 */
public class ListDeploymentInstancesRequest private constructor(builder: Builder) {
    /**
     * The unique ID of a deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A subset of instances to list by status:
     * + `Pending`: Include those instances with pending deployments.
     * + `InProgress`: Include those instances where deployments are still in progress.
     * + `Succeeded`: Include those instances with successful deployments.
     * + `Failed`: Include those instances with failed deployments.
     * + `Skipped`: Include those instances with skipped deployments.
     * + `Unknown`: Include those instances with deployments in an unknown state.
     */
    public val instanceStatusFilter: List<InstanceStatus>? = builder.instanceStatusFilter
    /**
     * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.
     */
    public val instanceTypeFilter: List<InstanceType>? = builder.instanceTypeFilter
    /**
     * An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListDeploymentInstancesRequest(")
        append("deploymentId=$deploymentId,")
        append("instanceStatusFilter=$instanceStatusFilter,")
        append("instanceTypeFilter=$instanceTypeFilter,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (instanceStatusFilter?.hashCode() ?: 0)
        result = 31 * result + (instanceTypeFilter?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListDeploymentInstancesRequest

        if (deploymentId != other.deploymentId) return false
        if (instanceStatusFilter != other.instanceStatusFilter) return false
        if (instanceTypeFilter != other.instanceTypeFilter) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of a deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * A subset of instances to list by status:
         * + `Pending`: Include those instances with pending deployments.
         * + `InProgress`: Include those instances where deployments are still in progress.
         * + `Succeeded`: Include those instances with successful deployments.
         * + `Failed`: Include those instances with failed deployments.
         * + `Skipped`: Include those instances with skipped deployments.
         * + `Unknown`: Include those instances with deployments in an unknown state.
         */
        public var instanceStatusFilter: List<InstanceStatus>? = null
        /**
         * The set of instances in a blue/green deployment, either those in the original environment ("BLUE") or those in the replacement environment ("GREEN"), for which you want to view instance information.
         */
        public var instanceTypeFilter: List<InstanceType>? = null
        /**
         * An identifier returned from the previous list deployment instances call. It can be used to return the next set of deployment instances in the list.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest) : this() {
            this.deploymentId = x.deploymentId
            this.instanceStatusFilter = x.instanceStatusFilter
            this.instanceTypeFilter = x.instanceTypeFilter
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ListDeploymentInstancesRequest = ListDeploymentInstancesRequest(this)
    }
}
