// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `ListApplicationRevisions` operation.
 */
public class ListApplicationRevisionsRequest private constructor(builder: Builder) {
    /**
     * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Whether to list revisions based on whether the revision is the target revision of a deployment group:
     * + `include`: List revisions that are target revisions of a deployment group.
     * + `exclude`: Do not list revisions that are target revisions of a deployment group.
     * + `ignore`: List all revisions.
     */
    public val deployed: aws.sdk.kotlin.services.codedeploy.model.ListStateFilterAction? = builder.deployed
    /**
     * An identifier returned from the previous `ListApplicationRevisions` call. It can be used to return the next set of applications in the list.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * An Amazon S3 bucket name to limit the search for revisions.
     *
     *  If set to null, all of the user's buckets are searched.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix
    /**
     * The column name to use to sort the list results:
     * + `registerTime`: Sort by the time the revisions were registered with CodeDeploy.
     * + `firstUsedTime`: Sort by the time the revisions were first used in a deployment.
     * + `lastUsedTime`: Sort by the time the revisions were last used in a deployment.
     *
     *  If not specified or set to null, the results are returned in an arbitrary order.
     */
    public val sortBy: aws.sdk.kotlin.services.codedeploy.model.ApplicationRevisionSortBy? = builder.sortBy
    /**
     * The order in which to sort the list results:
     * + `ascending`: ascending order.
     * + `descending`: descending order.
     *
     * If not specified, the results are sorted in ascending order.
     *
     * If set to null, the results are sorted in an arbitrary order.
     */
    public val sortOrder: aws.sdk.kotlin.services.codedeploy.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListApplicationRevisionsRequest(")
        append("applicationName=$applicationName,")
        append("deployed=$deployed,")
        append("nextToken=$nextToken,")
        append("s3Bucket=$s3Bucket,")
        append("s3KeyPrefix=$s3KeyPrefix,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (deployed?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListApplicationRevisionsRequest

        if (applicationName != other.applicationName) return false
        if (deployed != other.deployed) return false
        if (nextToken != other.nextToken) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Whether to list revisions based on whether the revision is the target revision of a deployment group:
         * + `include`: List revisions that are target revisions of a deployment group.
         * + `exclude`: Do not list revisions that are target revisions of a deployment group.
         * + `ignore`: List all revisions.
         */
        public var deployed: aws.sdk.kotlin.services.codedeploy.model.ListStateFilterAction? = null
        /**
         * An identifier returned from the previous `ListApplicationRevisions` call. It can be used to return the next set of applications in the list.
         */
        public var nextToken: kotlin.String? = null
        /**
         * An Amazon S3 bucket name to limit the search for revisions.
         *
         *  If set to null, all of the user's buckets are searched.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * A key prefix for the set of Amazon S3 objects to limit the search for revisions.
         */
        public var s3KeyPrefix: kotlin.String? = null
        /**
         * The column name to use to sort the list results:
         * + `registerTime`: Sort by the time the revisions were registered with CodeDeploy.
         * + `firstUsedTime`: Sort by the time the revisions were first used in a deployment.
         * + `lastUsedTime`: Sort by the time the revisions were last used in a deployment.
         *
         *  If not specified or set to null, the results are returned in an arbitrary order.
         */
        public var sortBy: aws.sdk.kotlin.services.codedeploy.model.ApplicationRevisionSortBy? = null
        /**
         * The order in which to sort the list results:
         * + `ascending`: ascending order.
         * + `descending`: descending order.
         *
         * If not specified, the results are sorted in ascending order.
         *
         * If set to null, the results are sorted in an arbitrary order.
         */
        public var sortOrder: aws.sdk.kotlin.services.codedeploy.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest) : this() {
            this.applicationName = x.applicationName
            this.deployed = x.deployed
            this.nextToken = x.nextToken
            this.s3Bucket = x.s3Bucket
            this.s3KeyPrefix = x.s3KeyPrefix
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.ListApplicationRevisionsRequest = ListApplicationRevisionsRequest(this)
    }
}
