// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A target Amazon EC2 or on-premises instance during a deployment that uses the EC2/On-premises compute platform.
 */
public class InstanceTarget private constructor(builder: Builder) {
    /**
     * The unique ID of a deployment.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * A label that identifies whether the instance is an original target (`BLUE`) or a replacement target (`GREEN`).
     */
    public val instanceLabel: aws.sdk.kotlin.services.codedeploy.model.TargetLabel? = builder.instanceLabel
    /**
     * The date and time when the target instance was updated by a deployment.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * The lifecycle events of the deployment to this target instance.
     */
    public val lifecycleEvents: List<LifecycleEvent>? = builder.lifecycleEvents
    /**
     * The status an EC2/On-premises deployment's target instance.
     */
    public val status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = builder.status
    /**
     * The Amazon Resource Name (ARN) of the target.
     */
    public val targetArn: kotlin.String? = builder.targetArn
    /**
     * The unique ID of a deployment target that has a type of `instanceTarget`.
     */
    public val targetId: kotlin.String? = builder.targetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.InstanceTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceTarget(")
        append("deploymentId=$deploymentId,")
        append("instanceLabel=$instanceLabel,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("lifecycleEvents=$lifecycleEvents,")
        append("status=$status,")
        append("targetArn=$targetArn,")
        append("targetId=$targetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deploymentId?.hashCode() ?: 0
        result = 31 * result + (instanceLabel?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (lifecycleEvents?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        result = 31 * result + (targetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceTarget

        if (deploymentId != other.deploymentId) return false
        if (instanceLabel != other.instanceLabel) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (lifecycleEvents != other.lifecycleEvents) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false
        if (targetId != other.targetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.InstanceTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID of a deployment.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * A label that identifies whether the instance is an original target (`BLUE`) or a replacement target (`GREEN`).
         */
        public var instanceLabel: aws.sdk.kotlin.services.codedeploy.model.TargetLabel? = null
        /**
         * The date and time when the target instance was updated by a deployment.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The lifecycle events of the deployment to this target instance.
         */
        public var lifecycleEvents: List<LifecycleEvent>? = null
        /**
         * The status an EC2/On-premises deployment's target instance.
         */
        public var status: aws.sdk.kotlin.services.codedeploy.model.TargetStatus? = null
        /**
         * The Amazon Resource Name (ARN) of the target.
         */
        public var targetArn: kotlin.String? = null
        /**
         * The unique ID of a deployment target that has a type of `instanceTarget`.
         */
        public var targetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.InstanceTarget) : this() {
            this.deploymentId = x.deploymentId
            this.instanceLabel = x.instanceLabel
            this.lastUpdatedAt = x.lastUpdatedAt
            this.lifecycleEvents = x.lifecycleEvents
            this.status = x.status
            this.targetArn = x.targetArn
            this.targetId = x.targetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.InstanceTarget = InstanceTarget(this)
    }
}
