// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about the deployment target.
 */
public class DeploymentTarget private constructor(builder: Builder) {
    /**
     * Information about the target to be updated by an CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.
     */
    public val cloudFormationTarget: aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget? = builder.cloudFormationTarget
    /**
     * The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.
     */
    public val deploymentTargetType: aws.sdk.kotlin.services.codedeploy.model.DeploymentTargetType? = builder.deploymentTargetType
    /**
     * Information about the target for a deployment that uses the Amazon ECS compute platform.
     */
    public val ecsTarget: aws.sdk.kotlin.services.codedeploy.model.EcsTarget? = builder.ecsTarget
    /**
     * Information about the target for a deployment that uses the EC2/On-premises compute platform.
     */
    public val instanceTarget: aws.sdk.kotlin.services.codedeploy.model.InstanceTarget? = builder.instanceTarget
    /**
     * Information about the target for a deployment that uses the Lambda compute platform.
     */
    public val lambdaTarget: aws.sdk.kotlin.services.codedeploy.model.LambdaTarget? = builder.lambdaTarget

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeploymentTarget(")
        append("cloudFormationTarget=$cloudFormationTarget,")
        append("deploymentTargetType=$deploymentTargetType,")
        append("ecsTarget=$ecsTarget,")
        append("instanceTarget=$instanceTarget,")
        append("lambdaTarget=$lambdaTarget")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudFormationTarget?.hashCode() ?: 0
        result = 31 * result + (deploymentTargetType?.hashCode() ?: 0)
        result = 31 * result + (ecsTarget?.hashCode() ?: 0)
        result = 31 * result + (instanceTarget?.hashCode() ?: 0)
        result = 31 * result + (lambdaTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeploymentTarget

        if (cloudFormationTarget != other.cloudFormationTarget) return false
        if (deploymentTargetType != other.deploymentTargetType) return false
        if (ecsTarget != other.ecsTarget) return false
        if (instanceTarget != other.instanceTarget) return false
        if (lambdaTarget != other.lambdaTarget) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about the target to be updated by an CloudFormation blue/green deployment. This target type is used for all deployments initiated by a CloudFormation stack update.
         */
        public var cloudFormationTarget: aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget? = null
        /**
         * The deployment type that is specific to the deployment's compute platform or deployments initiated by a CloudFormation stack update.
         */
        public var deploymentTargetType: aws.sdk.kotlin.services.codedeploy.model.DeploymentTargetType? = null
        /**
         * Information about the target for a deployment that uses the Amazon ECS compute platform.
         */
        public var ecsTarget: aws.sdk.kotlin.services.codedeploy.model.EcsTarget? = null
        /**
         * Information about the target for a deployment that uses the EC2/On-premises compute platform.
         */
        public var instanceTarget: aws.sdk.kotlin.services.codedeploy.model.InstanceTarget? = null
        /**
         * Information about the target for a deployment that uses the Lambda compute platform.
         */
        public var lambdaTarget: aws.sdk.kotlin.services.codedeploy.model.LambdaTarget? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget) : this() {
            this.cloudFormationTarget = x.cloudFormationTarget
            this.deploymentTargetType = x.deploymentTargetType
            this.ecsTarget = x.ecsTarget
            this.instanceTarget = x.instanceTarget
            this.lambdaTarget = x.lambdaTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.DeploymentTarget = DeploymentTarget(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget] inside the given [block]
         */
        public fun cloudFormationTarget(block: aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget.Builder.() -> kotlin.Unit) {
            this.cloudFormationTarget = aws.sdk.kotlin.services.codedeploy.model.CloudFormationTarget.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.EcsTarget] inside the given [block]
         */
        public fun ecsTarget(block: aws.sdk.kotlin.services.codedeploy.model.EcsTarget.Builder.() -> kotlin.Unit) {
            this.ecsTarget = aws.sdk.kotlin.services.codedeploy.model.EcsTarget.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.InstanceTarget] inside the given [block]
         */
        public fun instanceTarget(block: aws.sdk.kotlin.services.codedeploy.model.InstanceTarget.Builder.() -> kotlin.Unit) {
            this.instanceTarget = aws.sdk.kotlin.services.codedeploy.model.InstanceTarget.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.LambdaTarget] inside the given [block]
         */
        public fun lambdaTarget(block: aws.sdk.kotlin.services.codedeploy.model.LambdaTarget.Builder.() -> kotlin.Unit) {
            this.lambdaTarget = aws.sdk.kotlin.services.codedeploy.model.LambdaTarget.invoke(block)
        }
    }
}
