// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Represents the input of a `CreateDeployment` operation.
 */
public class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
     */
    public val applicationName: kotlin.String? = builder.applicationName
    /**
     * Configuration information for an automatic rollback that is added when a deployment is created.
     */
    public val autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = builder.autoRollbackConfiguration
    /**
     * The name of a deployment configuration associated with the IAM user or Amazon Web Services account.
     *
     * If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, `CodeDeployDefault`.`OneAtATime` is used by default.
     */
    public val deploymentConfigName: kotlin.String? = builder.deploymentConfigName
    /**
     * The name of the deployment group.
     */
    public val deploymentGroupName: kotlin.String? = builder.deploymentGroupName
    /**
     * A comment about the deployment.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.
     *
     * The `fileExistsBehavior` parameter takes any of the following values:
     * + DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
     * + OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.
     * + RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
     */
    public val fileExistsBehavior: aws.sdk.kotlin.services.codedeploy.model.FileExistsBehavior? = builder.fileExistsBehavior
    /**
     * If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if `ApplicationStop` fails, the deployment continues with `DownloadBundle`. If `BeforeBlockTraffic` fails, the deployment continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the deployment continues with `ApplicationStop`.
     *
     *  If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
     *
     *  During a deployment, the CodeDeploy agent runs the scripts specified for `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
     *
     *  If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use `ignoreApplicationStopFailures` to specify that the `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` failures should be ignored.
     */
    public val ignoreApplicationStopFailures: kotlin.Boolean = builder.ignoreApplicationStopFailures
    /**
     * Allows you to specify information about alarms associated with a deployment. The alarm configuration that you specify here will override the alarm configuration at the deployment group level. Consider overriding the alarm configuration if you have set up alarms at the deployment group level that are causing deployment failures. In this case, you would call `CreateDeployment` to create a new deployment that uses a previous application revision that is known to work, and set its alarm configuration to turn off alarm polling. Turning off alarm polling ensures that the new deployment proceeds without being blocked by the alarm that was generated by the previous, failed, deployment.
     *
     * If you specify an `overrideAlarmConfiguration`, you need the `UpdateDeploymentGroup` IAM permission when calling `CreateDeployment`.
     */
    public val overrideAlarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = builder.overrideAlarmConfiguration
    /**
     * The type and location of the revision to deploy.
     */
    public val revision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = builder.revision
    /**
     * Information about the instances that belong to the replacement environment in a blue/green deployment.
     */
    public val targetInstances: aws.sdk.kotlin.services.codedeploy.model.TargetInstances? = builder.targetInstances
    /**
     * Indicates whether to deploy to all instances or only to instances that are not running the latest application revision.
     */
    public val updateOutdatedInstancesOnly: kotlin.Boolean = builder.updateOutdatedInstancesOnly

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("applicationName=$applicationName,")
        append("autoRollbackConfiguration=$autoRollbackConfiguration,")
        append("deploymentConfigName=$deploymentConfigName,")
        append("deploymentGroupName=$deploymentGroupName,")
        append("description=$description,")
        append("fileExistsBehavior=$fileExistsBehavior,")
        append("ignoreApplicationStopFailures=$ignoreApplicationStopFailures,")
        append("overrideAlarmConfiguration=$overrideAlarmConfiguration,")
        append("revision=$revision,")
        append("targetInstances=$targetInstances,")
        append("updateOutdatedInstancesOnly=$updateOutdatedInstancesOnly")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationName?.hashCode() ?: 0
        result = 31 * result + (autoRollbackConfiguration?.hashCode() ?: 0)
        result = 31 * result + (deploymentConfigName?.hashCode() ?: 0)
        result = 31 * result + (deploymentGroupName?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fileExistsBehavior?.hashCode() ?: 0)
        result = 31 * result + (ignoreApplicationStopFailures.hashCode())
        result = 31 * result + (overrideAlarmConfiguration?.hashCode() ?: 0)
        result = 31 * result + (revision?.hashCode() ?: 0)
        result = 31 * result + (targetInstances?.hashCode() ?: 0)
        result = 31 * result + (updateOutdatedInstancesOnly.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (applicationName != other.applicationName) return false
        if (autoRollbackConfiguration != other.autoRollbackConfiguration) return false
        if (deploymentConfigName != other.deploymentConfigName) return false
        if (deploymentGroupName != other.deploymentGroupName) return false
        if (description != other.description) return false
        if (fileExistsBehavior != other.fileExistsBehavior) return false
        if (ignoreApplicationStopFailures != other.ignoreApplicationStopFailures) return false
        if (overrideAlarmConfiguration != other.overrideAlarmConfiguration) return false
        if (revision != other.revision) return false
        if (targetInstances != other.targetInstances) return false
        if (updateOutdatedInstancesOnly != other.updateOutdatedInstancesOnly) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of an CodeDeploy application associated with the IAM user or Amazon Web Services account.
         */
        public var applicationName: kotlin.String? = null
        /**
         * Configuration information for an automatic rollback that is added when a deployment is created.
         */
        public var autoRollbackConfiguration: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration? = null
        /**
         * The name of a deployment configuration associated with the IAM user or Amazon Web Services account.
         *
         * If not specified, the value configured in the deployment group is used as the default. If the deployment group does not have a deployment configuration associated with it, `CodeDeployDefault`.`OneAtATime` is used by default.
         */
        public var deploymentConfigName: kotlin.String? = null
        /**
         * The name of the deployment group.
         */
        public var deploymentGroupName: kotlin.String? = null
        /**
         * A comment about the deployment.
         */
        public var description: kotlin.String? = null
        /**
         * Information about how CodeDeploy handles files that already exist in a deployment target location but weren't part of the previous successful deployment.
         *
         * The `fileExistsBehavior` parameter takes any of the following values:
         * + DISALLOW: The deployment fails. This is also the default behavior if no option is specified.
         * + OVERWRITE: The version of the file from the application revision currently being deployed replaces the version already on the instance.
         * + RETAIN: The version of the file already on the instance is kept and used as part of the new deployment.
         */
        public var fileExistsBehavior: aws.sdk.kotlin.services.codedeploy.model.FileExistsBehavior? = null
        /**
         * If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or `AfterBlockTraffic` deployment lifecycle event to an instance fails, then the deployment continues to the next deployment lifecycle event. For example, if `ApplicationStop` fails, the deployment continues with `DownloadBundle`. If `BeforeBlockTraffic` fails, the deployment continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the deployment continues with `ApplicationStop`.
         *
         *  If false or not specified, then if a lifecycle event fails during a deployment to an instance, that deployment fails. If deployment to that instance is part of an overall deployment and the number of healthy hosts is not less than the minimum number of healthy hosts, then a deployment to the next instance is attempted.
         *
         *  During a deployment, the CodeDeploy agent runs the scripts specified for `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in the AppSpec file from the previous successful deployment. (All other scripts are run from the AppSpec file in the current deployment.) If one of these scripts contains an error and does not run successfully, the deployment can fail.
         *
         *  If the cause of the failure is a script from the last successful deployment that will never run successfully, create a new deployment and use `ignoreApplicationStopFailures` to specify that the `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` failures should be ignored.
         */
        public var ignoreApplicationStopFailures: kotlin.Boolean = false
        /**
         * Allows you to specify information about alarms associated with a deployment. The alarm configuration that you specify here will override the alarm configuration at the deployment group level. Consider overriding the alarm configuration if you have set up alarms at the deployment group level that are causing deployment failures. In this case, you would call `CreateDeployment` to create a new deployment that uses a previous application revision that is known to work, and set its alarm configuration to turn off alarm polling. Turning off alarm polling ensures that the new deployment proceeds without being blocked by the alarm that was generated by the previous, failed, deployment.
         *
         * If you specify an `overrideAlarmConfiguration`, you need the `UpdateDeploymentGroup` IAM permission when calling `CreateDeployment`.
         */
        public var overrideAlarmConfiguration: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration? = null
        /**
         * The type and location of the revision to deploy.
         */
        public var revision: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation? = null
        /**
         * Information about the instances that belong to the replacement environment in a blue/green deployment.
         */
        public var targetInstances: aws.sdk.kotlin.services.codedeploy.model.TargetInstances? = null
        /**
         * Indicates whether to deploy to all instances or only to instances that are not running the latest application revision.
         */
        public var updateOutdatedInstancesOnly: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentRequest) : this() {
            this.applicationName = x.applicationName
            this.autoRollbackConfiguration = x.autoRollbackConfiguration
            this.deploymentConfigName = x.deploymentConfigName
            this.deploymentGroupName = x.deploymentGroupName
            this.description = x.description
            this.fileExistsBehavior = x.fileExistsBehavior
            this.ignoreApplicationStopFailures = x.ignoreApplicationStopFailures
            this.overrideAlarmConfiguration = x.overrideAlarmConfiguration
            this.revision = x.revision
            this.targetInstances = x.targetInstances
            this.updateOutdatedInstancesOnly = x.updateOutdatedInstancesOnly
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration] inside the given [block]
         */
        public fun autoRollbackConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.Builder.() -> kotlin.Unit) {
            this.autoRollbackConfiguration = aws.sdk.kotlin.services.codedeploy.model.AutoRollbackConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration] inside the given [block]
         */
        public fun overrideAlarmConfiguration(block: aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.overrideAlarmConfiguration = aws.sdk.kotlin.services.codedeploy.model.AlarmConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.RevisionLocation] inside the given [block]
         */
        public fun revision(block: aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.Builder.() -> kotlin.Unit) {
            this.revision = aws.sdk.kotlin.services.codedeploy.model.RevisionLocation.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codedeploy.model.TargetInstances] inside the given [block]
         */
        public fun targetInstances(block: aws.sdk.kotlin.services.codedeploy.model.TargetInstances.Builder.() -> kotlin.Unit) {
            this.targetInstances = aws.sdk.kotlin.services.codedeploy.model.TargetInstances.invoke(block)
        }
    }
}
