// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.codedeploy.model.CodeDeployException
import aws.sdk.kotlin.services.codedeploy.model.SkipWaitTimeForInstanceTerminationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class SkipWaitTimeForInstanceTerminationOperationDeserializer: HttpDeserialize<SkipWaitTimeForInstanceTerminationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SkipWaitTimeForInstanceTerminationResponse {
        if (!response.status.isSuccess()) {
            throwSkipWaitTimeForInstanceTerminationError(context, response)
        }
        val builder = SkipWaitTimeForInstanceTerminationResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwSkipWaitTimeForInstanceTerminationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw CodeDeployException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DeploymentAlreadyCompletedException" -> DeploymentAlreadyCompletedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentDoesNotExistException" -> DeploymentDoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentIdRequiredException" -> DeploymentIdRequiredExceptionDeserializer().deserialize(context, wrappedResponse)
        "DeploymentNotStartedException" -> DeploymentNotStartedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidDeploymentIdException" -> InvalidDeploymentIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedActionForDeploymentTypeException" -> UnsupportedActionForDeploymentTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> CodeDeployException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
