// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy.model



/**
 * Information about whether instances in the original environment are terminated when a blue/green deployment is successful. `BlueInstanceTerminationOption` does not apply to Lambda deployments.
 */
class BlueInstanceTerminationOption private constructor(builder: Builder) {
    /**
     * The action to take on instances in the original environment after a successful blue/green deployment.
     * + `TERMINATE`: Instances are terminated after a specified wait time.
     * + `KEEP_ALIVE`: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.
     */
    val action: aws.sdk.kotlin.services.codedeploy.model.InstanceAction? = builder.action
    /**
     * For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
     *
     *  For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set.
     *
     *  The maximum setting is 2880 minutes (2 days).
     */
    val terminationWaitTimeInMinutes: kotlin.Int = builder.terminationWaitTimeInMinutes

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codedeploy.model.BlueInstanceTerminationOption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlueInstanceTerminationOption(")
        append("action=$action,")
        append("terminationWaitTimeInMinutes=$terminationWaitTimeInMinutes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (terminationWaitTimeInMinutes)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlueInstanceTerminationOption

        if (action != other.action) return false
        if (terminationWaitTimeInMinutes != other.terminationWaitTimeInMinutes) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codedeploy.model.BlueInstanceTerminationOption = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action to take on instances in the original environment after a successful blue/green deployment.
         * + `TERMINATE`: Instances are terminated after a specified wait time.
         * + `KEEP_ALIVE`: Instances are left running after they are deregistered from the load balancer and removed from the deployment group.
         */
        var action: aws.sdk.kotlin.services.codedeploy.model.InstanceAction? = null
        /**
         * For an Amazon EC2 deployment, the number of minutes to wait after a successful blue/green deployment before terminating instances from the original environment.
         *
         *  For an Amazon ECS deployment, the number of minutes before deleting the original (blue) task set. During an Amazon ECS deployment, CodeDeploy shifts traffic from the original (blue) task set to a replacement (green) task set.
         *
         *  The maximum setting is 2880 minutes (2 days).
         */
        var terminationWaitTimeInMinutes: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codedeploy.model.BlueInstanceTerminationOption) : this() {
            this.action = x.action
            this.terminationWaitTimeInMinutes = x.terminationWaitTimeInMinutes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codedeploy.model.BlueInstanceTerminationOption = BlueInstanceTerminationOption(this)
    }
}
