// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codedeploy

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codedeploy.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.codedeploy.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS CodeDeploy
 * AWS CodeDeploy is a deployment service that automates application deployments to Amazon EC2 instances, on-premises instances running in your own facility, serverless AWS Lambda functions, or applications in an Amazon ECS service.
 *
 * You can deploy a nearly unlimited variety of application content, such as an updated Lambda function, updated applications in an Amazon ECS service, code, web and configuration files, executables, packages, scripts, multimedia files, and so on. AWS CodeDeploy can deploy application content stored in Amazon S3 buckets, GitHub repositories, or Bitbucket repositories. You do not need to make changes to your existing code before you can use AWS CodeDeploy.
 *
 * AWS CodeDeploy makes it easier for you to rapidly release new features, helps you avoid downtime during application deployment, and handles the complexity of updating your applications, without many of the risks associated with error-prone manual deployments.
 *
 * **AWS CodeDeploy Components**
 *
 * Use the information in this guide to help you work with the following AWS CodeDeploy components:
 * + **Application**: A name that uniquely identifies the application you want to deploy. AWS CodeDeploy uses this name, which functions as a container, to ensure the correct combination of revision, deployment configuration, and deployment group are referenced during a deployment.
 * + **Deployment group**: A set of individual instances, CodeDeploy Lambda deployment configuration settings, or an Amazon ECS service and network details. A Lambda deployment group specifies how to route traffic to a new version of a Lambda function. An Amazon ECS deployment group specifies the service created in Amazon ECS to deploy, a load balancer, and a listener to reroute production traffic to an updated containerized application. An EC2/On-premises deployment group contains individually tagged instances, Amazon EC2 instances in Amazon EC2 Auto Scaling groups, or both. All deployment groups can specify optional trigger, alarm, and rollback settings.
 * + **Deployment configuration**: A set of deployment rules and deployment success and failure conditions used by AWS CodeDeploy during a deployment.
 * + **Deployment**: The process and the components used when updating a Lambda function, a containerized application in an Amazon ECS service, or of installing content on one or more instances.
 * + **Application revisions**: For an AWS Lambda deployment, this is an AppSpec file that specifies the Lambda function to be updated and one or more functions to validate deployment lifecycle events. For an Amazon ECS deployment, this is an AppSpec file that specifies the Amazon ECS task definition, container, and port where production traffic is rerouted. For an EC2/On-premises deployment, this is an archive file that contains source content—source code, webpages, executable files, and deployment scripts—along with an AppSpec file. Revisions are stored in Amazon S3 buckets or GitHub repositories. For Amazon S3, a revision is uniquely identified by its Amazon S3 object key and its ETag, version, or both. For GitHub, a revision is uniquely identified by its commit ID.
 *
 * This guide also contains information to help you get details about the instances in your deployments, to make on-premises instances available for AWS CodeDeploy deployments, to get details about a Lambda function deployment, and to get details about Amazon ECS service deployments.
 *
 * **AWS CodeDeploy Information Resources**
 * + [AWS CodeDeploy User Guide](https://docs.aws.amazon.com/codedeploy/latest/userguide)
 * + [AWS CodeDeploy API Reference Guide](https://docs.aws.amazon.com/codedeploy/latest/APIReference/)
 * + [AWS CLI Reference for AWS CodeDeploy](https://docs.aws.amazon.com/cli/latest/reference/deploy/index.html)
 * + [AWS CodeDeploy Developer Forum](https://forums.aws.amazon.com/forum.jspa?forumID=179)
 */
interface CodeDeployClient : SdkClient {

    override val serviceName: String
        get() = "CodeDeploy"
    /**
     * CodeDeployClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): CodeDeployClient {
            val config = Config.Builder().apply(block).build()
            return DefaultCodeDeployClient(config)
        }

        operator fun invoke(config: Config): CodeDeployClient = DefaultCodeDeployClient(config)

        /**
         * Construct a [CodeDeployClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): CodeDeployClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultCodeDeployClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds tags to on-premises instances.
     */
    suspend fun addTagsToOnPremisesInstances(input: AddTagsToOnPremisesInstancesRequest): AddTagsToOnPremisesInstancesResponse

    /**
     * Adds tags to on-premises instances.
     */
    suspend fun addTagsToOnPremisesInstances(block: AddTagsToOnPremisesInstancesRequest.Builder.() -> Unit) = addTagsToOnPremisesInstances(AddTagsToOnPremisesInstancesRequest.Builder().apply(block).build())

    /**
     * Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
     */
    suspend fun batchGetApplicationRevisions(input: BatchGetApplicationRevisionsRequest): BatchGetApplicationRevisionsResponse

    /**
     * Gets information about one or more application revisions. The maximum number of application revisions that can be returned is 25.
     */
    suspend fun batchGetApplicationRevisions(block: BatchGetApplicationRevisionsRequest.Builder.() -> Unit) = batchGetApplicationRevisions(BatchGetApplicationRevisionsRequest.Builder().apply(block).build())

    /**
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     */
    suspend fun batchGetApplications(input: BatchGetApplicationsRequest): BatchGetApplicationsResponse

    /**
     * Gets information about one or more applications. The maximum number of applications that can be returned is 100.
     */
    suspend fun batchGetApplications(block: BatchGetApplicationsRequest.Builder.() -> Unit) = batchGetApplications(BatchGetApplicationsRequest.Builder().apply(block).build())

    /**
     * Gets information about one or more deployment groups.
     */
    suspend fun batchGetDeploymentGroups(input: BatchGetDeploymentGroupsRequest): BatchGetDeploymentGroupsResponse

    /**
     * Gets information about one or more deployment groups.
     */
    suspend fun batchGetDeploymentGroups(block: BatchGetDeploymentGroupsRequest.Builder.() -> Unit) = batchGetDeploymentGroups(BatchGetDeploymentGroupsRequest.Builder().apply(block).build())

    /**
     * This method works, but is deprecated. Use `BatchGetDeploymentTargets` instead.
     *
     *  Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and AWS Lambda compute platforms. The newer `BatchGetDeploymentTargets` works with all compute platforms. The maximum number of instances that can be returned is 25.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun batchGetDeploymentInstances(input: BatchGetDeploymentInstancesRequest): BatchGetDeploymentInstancesResponse

    /**
     * This method works, but is deprecated. Use `BatchGetDeploymentTargets` instead.
     *
     *  Returns an array of one or more instances associated with a deployment. This method works with EC2/On-premises and AWS Lambda compute platforms. The newer `BatchGetDeploymentTargets` works with all compute platforms. The maximum number of instances that can be returned is 25.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun batchGetDeploymentInstances(block: BatchGetDeploymentInstancesRequest.Builder.() -> Unit) = batchGetDeploymentInstances(BatchGetDeploymentInstancesRequest.Builder().apply(block).build())

    /**
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated `BatchGetDeploymentInstances`. The maximum number of targets that can be returned is 25.
     *
     *  The type of targets returned depends on the deployment's compute platform or deployment method:
     * + **EC2/On-premises**: Information about EC2 instance targets.
     * + **AWS Lambda**: Information about Lambda functions targets.
     * + **Amazon ECS**: Information about Amazon ECS service targets.
     * + **CloudFormation**: Information about targets of blue/green deployments initiated by a CloudFormation stack update.
     */
    suspend fun batchGetDeploymentTargets(input: BatchGetDeploymentTargetsRequest = BatchGetDeploymentTargetsRequest {}): BatchGetDeploymentTargetsResponse

    /**
     * Returns an array of one or more targets associated with a deployment. This method works with all compute types and should be used instead of the deprecated `BatchGetDeploymentInstances`. The maximum number of targets that can be returned is 25.
     *
     *  The type of targets returned depends on the deployment's compute platform or deployment method:
     * + **EC2/On-premises**: Information about EC2 instance targets.
     * + **AWS Lambda**: Information about Lambda functions targets.
     * + **Amazon ECS**: Information about Amazon ECS service targets.
     * + **CloudFormation**: Information about targets of blue/green deployments initiated by a CloudFormation stack update.
     */
    suspend fun batchGetDeploymentTargets(block: BatchGetDeploymentTargetsRequest.Builder.() -> Unit) = batchGetDeploymentTargets(BatchGetDeploymentTargetsRequest.Builder().apply(block).build())

    /**
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     */
    suspend fun batchGetDeployments(input: BatchGetDeploymentsRequest): BatchGetDeploymentsResponse

    /**
     * Gets information about one or more deployments. The maximum number of deployments that can be returned is 25.
     */
    suspend fun batchGetDeployments(block: BatchGetDeploymentsRequest.Builder.() -> Unit) = batchGetDeployments(BatchGetDeploymentsRequest.Builder().apply(block).build())

    /**
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
     */
    suspend fun batchGetOnPremisesInstances(input: BatchGetOnPremisesInstancesRequest): BatchGetOnPremisesInstancesResponse

    /**
     * Gets information about one or more on-premises instances. The maximum number of on-premises instances that can be returned is 25.
     */
    suspend fun batchGetOnPremisesInstances(block: BatchGetOnPremisesInstancesRequest.Builder.() -> Unit) = batchGetOnPremisesInstances(BatchGetOnPremisesInstancesRequest.Builder().apply(block).build())

    /**
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
     */
    suspend fun continueDeployment(input: ContinueDeploymentRequest = ContinueDeploymentRequest {}): ContinueDeploymentResponse

    /**
     * For a blue/green deployment, starts the process of rerouting traffic from instances in the original environment to instances in the replacement environment without waiting for a specified wait time to elapse. (Traffic rerouting, which is achieved by registering instances in the replacement environment with the load balancer, can start as soon as all instances have a status of Ready.)
     */
    suspend fun continueDeployment(block: ContinueDeploymentRequest.Builder.() -> Unit) = continueDeployment(ContinueDeploymentRequest.Builder().apply(block).build())

    /**
     * Creates an application.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an application.
     */
    suspend fun createApplication(block: CreateApplicationRequest.Builder.() -> Unit) = createApplication(CreateApplicationRequest.Builder().apply(block).build())

    /**
     * Deploys an application revision through the specified deployment group.
     */
    suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Deploys an application revision through the specified deployment group.
     */
    suspend fun createDeployment(block: CreateDeploymentRequest.Builder.() -> Unit) = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

    /**
     * Creates a deployment configuration.
     */
    suspend fun createDeploymentConfig(input: CreateDeploymentConfigRequest): CreateDeploymentConfigResponse

    /**
     * Creates a deployment configuration.
     */
    suspend fun createDeploymentConfig(block: CreateDeploymentConfigRequest.Builder.() -> Unit) = createDeploymentConfig(CreateDeploymentConfigRequest.Builder().apply(block).build())

    /**
     * Creates a deployment group to which application revisions are deployed.
     */
    suspend fun createDeploymentGroup(input: CreateDeploymentGroupRequest): CreateDeploymentGroupResponse

    /**
     * Creates a deployment group to which application revisions are deployed.
     */
    suspend fun createDeploymentGroup(block: CreateDeploymentGroupRequest.Builder.() -> Unit) = createDeploymentGroup(CreateDeploymentGroupRequest.Builder().apply(block).build())

    /**
     * Deletes an application.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes an application.
     */
    suspend fun deleteApplication(block: DeleteApplicationRequest.Builder.() -> Unit) = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

    /**
     * Deletes a deployment configuration.
     *
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.
     */
    suspend fun deleteDeploymentConfig(input: DeleteDeploymentConfigRequest): DeleteDeploymentConfigResponse

    /**
     * Deletes a deployment configuration.
     *
     * A deployment configuration cannot be deleted if it is currently in use. Predefined configurations cannot be deleted.
     */
    suspend fun deleteDeploymentConfig(block: DeleteDeploymentConfigRequest.Builder.() -> Unit) = deleteDeploymentConfig(DeleteDeploymentConfigRequest.Builder().apply(block).build())

    /**
     * Deletes a deployment group.
     */
    suspend fun deleteDeploymentGroup(input: DeleteDeploymentGroupRequest): DeleteDeploymentGroupResponse

    /**
     * Deletes a deployment group.
     */
    suspend fun deleteDeploymentGroup(block: DeleteDeploymentGroupRequest.Builder.() -> Unit) = deleteDeploymentGroup(DeleteDeploymentGroupRequest.Builder().apply(block).build())

    /**
     * Deletes a GitHub account connection.
     */
    suspend fun deleteGitHubAccountToken(input: DeleteGitHubAccountTokenRequest = DeleteGitHubAccountTokenRequest {}): DeleteGitHubAccountTokenResponse

    /**
     * Deletes a GitHub account connection.
     */
    suspend fun deleteGitHubAccountToken(block: DeleteGitHubAccountTokenRequest.Builder.() -> Unit) = deleteGitHubAccountToken(DeleteGitHubAccountTokenRequest.Builder().apply(block).build())

    /**
     * Deletes resources linked to an external ID.
     */
    suspend fun deleteResourcesByExternalId(input: DeleteResourcesByExternalIdRequest = DeleteResourcesByExternalIdRequest {}): DeleteResourcesByExternalIdResponse

    /**
     * Deletes resources linked to an external ID.
     */
    suspend fun deleteResourcesByExternalId(block: DeleteResourcesByExternalIdRequest.Builder.() -> Unit) = deleteResourcesByExternalId(DeleteResourcesByExternalIdRequest.Builder().apply(block).build())

    /**
     * Deregisters an on-premises instance.
     */
    suspend fun deregisterOnPremisesInstance(input: DeregisterOnPremisesInstanceRequest): DeregisterOnPremisesInstanceResponse

    /**
     * Deregisters an on-premises instance.
     */
    suspend fun deregisterOnPremisesInstance(block: DeregisterOnPremisesInstanceRequest.Builder.() -> Unit) = deregisterOnPremisesInstance(DeregisterOnPremisesInstanceRequest.Builder().apply(block).build())

    /**
     * Gets information about an application.
     */
    suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets information about an application.
     */
    suspend fun getApplication(block: GetApplicationRequest.Builder.() -> Unit) = getApplication(GetApplicationRequest.Builder().apply(block).build())

    /**
     * Gets information about an application revision.
     */
    suspend fun getApplicationRevision(input: GetApplicationRevisionRequest): GetApplicationRevisionResponse

    /**
     * Gets information about an application revision.
     */
    suspend fun getApplicationRevision(block: GetApplicationRevisionRequest.Builder.() -> Unit) = getApplicationRevision(GetApplicationRevisionRequest.Builder().apply(block).build())

    /**
     * Gets information about a deployment.
     *
     *  The `content` property of the `appSpecContent` object in the returned revision is always null. Use `GetApplicationRevision` and the `sha256` property of the returned `appSpecContent` object to get the content of the deployment’s AppSpec file.
     */
    suspend fun getDeployment(input: GetDeploymentRequest): GetDeploymentResponse

    /**
     * Gets information about a deployment.
     *
     *  The `content` property of the `appSpecContent` object in the returned revision is always null. Use `GetApplicationRevision` and the `sha256` property of the returned `appSpecContent` object to get the content of the deployment’s AppSpec file.
     */
    suspend fun getDeployment(block: GetDeploymentRequest.Builder.() -> Unit) = getDeployment(GetDeploymentRequest.Builder().apply(block).build())

    /**
     * Gets information about a deployment configuration.
     */
    suspend fun getDeploymentConfig(input: GetDeploymentConfigRequest): GetDeploymentConfigResponse

    /**
     * Gets information about a deployment configuration.
     */
    suspend fun getDeploymentConfig(block: GetDeploymentConfigRequest.Builder.() -> Unit) = getDeploymentConfig(GetDeploymentConfigRequest.Builder().apply(block).build())

    /**
     * Gets information about a deployment group.
     */
    suspend fun getDeploymentGroup(input: GetDeploymentGroupRequest): GetDeploymentGroupResponse

    /**
     * Gets information about a deployment group.
     */
    suspend fun getDeploymentGroup(block: GetDeploymentGroupRequest.Builder.() -> Unit) = getDeploymentGroup(GetDeploymentGroupRequest.Builder().apply(block).build())

    /**
     * Gets information about an instance as part of a deployment.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun getDeploymentInstance(input: GetDeploymentInstanceRequest): GetDeploymentInstanceResponse

    /**
     * Gets information about an instance as part of a deployment.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun getDeploymentInstance(block: GetDeploymentInstanceRequest.Builder.() -> Unit) = getDeploymentInstance(GetDeploymentInstanceRequest.Builder().apply(block).build())

    /**
     * Returns information about a deployment target.
     */
    suspend fun getDeploymentTarget(input: GetDeploymentTargetRequest = GetDeploymentTargetRequest {}): GetDeploymentTargetResponse

    /**
     * Returns information about a deployment target.
     */
    suspend fun getDeploymentTarget(block: GetDeploymentTargetRequest.Builder.() -> Unit) = getDeploymentTarget(GetDeploymentTargetRequest.Builder().apply(block).build())

    /**
     * Gets information about an on-premises instance.
     */
    suspend fun getOnPremisesInstance(input: GetOnPremisesInstanceRequest): GetOnPremisesInstanceResponse

    /**
     * Gets information about an on-premises instance.
     */
    suspend fun getOnPremisesInstance(block: GetOnPremisesInstanceRequest.Builder.() -> Unit) = getOnPremisesInstance(GetOnPremisesInstanceRequest.Builder().apply(block).build())

    /**
     * Lists information about revisions for an application.
     */
    suspend fun listApplicationRevisions(input: ListApplicationRevisionsRequest): ListApplicationRevisionsResponse

    /**
     * Lists information about revisions for an application.
     */
    suspend fun listApplicationRevisions(block: ListApplicationRevisionsRequest.Builder.() -> Unit) = listApplicationRevisions(ListApplicationRevisionsRequest.Builder().apply(block).build())

    /**
     * Lists the applications registered with the IAM user or AWS account.
     */
    suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Lists the applications registered with the IAM user or AWS account.
     */
    suspend fun listApplications(block: ListApplicationsRequest.Builder.() -> Unit) = listApplications(ListApplicationsRequest.Builder().apply(block).build())

    /**
     * Lists the deployment configurations with the IAM user or AWS account.
     */
    suspend fun listDeploymentConfigs(input: ListDeploymentConfigsRequest = ListDeploymentConfigsRequest {}): ListDeploymentConfigsResponse

    /**
     * Lists the deployment configurations with the IAM user or AWS account.
     */
    suspend fun listDeploymentConfigs(block: ListDeploymentConfigsRequest.Builder.() -> Unit) = listDeploymentConfigs(ListDeploymentConfigsRequest.Builder().apply(block).build())

    /**
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     */
    suspend fun listDeploymentGroups(input: ListDeploymentGroupsRequest): ListDeploymentGroupsResponse

    /**
     * Lists the deployment groups for an application registered with the IAM user or AWS account.
     */
    suspend fun listDeploymentGroups(block: ListDeploymentGroupsRequest.Builder.() -> Unit) = listDeploymentGroups(ListDeploymentGroupsRequest.Builder().apply(block).build())

    /**
     * The newer `BatchGetDeploymentTargets` should be used instead because it works with all compute types. `ListDeploymentInstances` throws an exception if it is used with a compute platform other than EC2/On-premises or AWS Lambda.
     *
     *  Lists the instance for a deployment associated with the IAM user or AWS account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDeploymentInstances(input: ListDeploymentInstancesRequest): ListDeploymentInstancesResponse

    /**
     * The newer `BatchGetDeploymentTargets` should be used instead because it works with all compute types. `ListDeploymentInstances` throws an exception if it is used with a compute platform other than EC2/On-premises or AWS Lambda.
     *
     *  Lists the instance for a deployment associated with the IAM user or AWS account.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun listDeploymentInstances(block: ListDeploymentInstancesRequest.Builder.() -> Unit) = listDeploymentInstances(ListDeploymentInstancesRequest.Builder().apply(block).build())

    /**
     * Returns an array of target IDs that are associated a deployment.
     */
    suspend fun listDeploymentTargets(input: ListDeploymentTargetsRequest = ListDeploymentTargetsRequest {}): ListDeploymentTargetsResponse

    /**
     * Returns an array of target IDs that are associated a deployment.
     */
    suspend fun listDeploymentTargets(block: ListDeploymentTargetsRequest.Builder.() -> Unit) = listDeploymentTargets(ListDeploymentTargetsRequest.Builder().apply(block).build())

    /**
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     */
    suspend fun listDeployments(input: ListDeploymentsRequest = ListDeploymentsRequest {}): ListDeploymentsResponse

    /**
     * Lists the deployments in a deployment group for an application registered with the IAM user or AWS account.
     */
    suspend fun listDeployments(block: ListDeploymentsRequest.Builder.() -> Unit) = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

    /**
     * Lists the names of stored connections to GitHub accounts.
     */
    suspend fun listGitHubAccountTokenNames(input: ListGitHubAccountTokenNamesRequest = ListGitHubAccountTokenNamesRequest {}): ListGitHubAccountTokenNamesResponse

    /**
     * Lists the names of stored connections to GitHub accounts.
     */
    suspend fun listGitHubAccountTokenNames(block: ListGitHubAccountTokenNamesRequest.Builder.() -> Unit) = listGitHubAccountTokenNames(ListGitHubAccountTokenNamesRequest.Builder().apply(block).build())

    /**
     * Gets a list of names for one or more on-premises instances.
     *
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.
     */
    suspend fun listOnPremisesInstances(input: ListOnPremisesInstancesRequest = ListOnPremisesInstancesRequest {}): ListOnPremisesInstancesResponse

    /**
     * Gets a list of names for one or more on-premises instances.
     *
     * Unless otherwise specified, both registered and deregistered on-premises instance names are listed. To list only registered or deregistered on-premises instance names, use the registration status parameter.
     */
    suspend fun listOnPremisesInstances(block: ListOnPremisesInstancesRequest.Builder.() -> Unit) = listOnPremisesInstances(ListOnPremisesInstancesRequest.Builder().apply(block).build())

    /**
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of tags for the resource identified by a specified Amazon Resource Name (ARN). Tags are used to organize and categorize your CodeDeploy resources.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an AWS Lambda Deployment ](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
     */
    suspend fun putLifecycleEventHookExecutionStatus(input: PutLifecycleEventHookExecutionStatusRequest = PutLifecycleEventHookExecutionStatusRequest {}): PutLifecycleEventHookExecutionStatusResponse

    /**
     * Sets the result of a Lambda validation function. The function validates lifecycle hooks during a deployment that uses the AWS Lambda or Amazon ECS compute platform. For AWS Lambda deployments, the available lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For Amazon ECS deployments, the available lifecycle hooks are `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`, `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation functions return `Succeeded` or `Failed`. For more information, see [AppSpec 'hooks' Section for an AWS Lambda Deployment ](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda) and [AppSpec 'hooks' Section for an Amazon ECS Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
     */
    suspend fun putLifecycleEventHookExecutionStatus(block: PutLifecycleEventHookExecutionStatusRequest.Builder.() -> Unit) = putLifecycleEventHookExecutionStatus(PutLifecycleEventHookExecutionStatusRequest.Builder().apply(block).build())

    /**
     * Registers with AWS CodeDeploy a revision for the specified application.
     */
    suspend fun registerApplicationRevision(input: RegisterApplicationRevisionRequest): RegisterApplicationRevisionResponse

    /**
     * Registers with AWS CodeDeploy a revision for the specified application.
     */
    suspend fun registerApplicationRevision(block: RegisterApplicationRevisionRequest.Builder.() -> Unit) = registerApplicationRevision(RegisterApplicationRevisionRequest.Builder().apply(block).build())

    /**
     * Registers an on-premises instance.
     *
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     */
    suspend fun registerOnPremisesInstance(input: RegisterOnPremisesInstanceRequest): RegisterOnPremisesInstanceResponse

    /**
     * Registers an on-premises instance.
     *
     * Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in the request. You cannot use both.
     */
    suspend fun registerOnPremisesInstance(block: RegisterOnPremisesInstanceRequest.Builder.() -> Unit) = registerOnPremisesInstance(RegisterOnPremisesInstanceRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from one or more on-premises instances.
     */
    suspend fun removeTagsFromOnPremisesInstances(input: RemoveTagsFromOnPremisesInstancesRequest): RemoveTagsFromOnPremisesInstancesResponse

    /**
     * Removes one or more tags from one or more on-premises instances.
     */
    suspend fun removeTagsFromOnPremisesInstances(block: RemoveTagsFromOnPremisesInstancesRequest.Builder.() -> Unit) = removeTagsFromOnPremisesInstances(RemoveTagsFromOnPremisesInstancesRequest.Builder().apply(block).build())

    /**
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun skipWaitTimeForInstanceTermination(input: SkipWaitTimeForInstanceTerminationRequest = SkipWaitTimeForInstanceTerminationRequest {}): SkipWaitTimeForInstanceTerminationResponse

    /**
     * In a blue/green deployment, overrides any specified wait time and starts terminating instances immediately after the traffic routing is complete.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun skipWaitTimeForInstanceTermination(block: SkipWaitTimeForInstanceTerminationRequest.Builder.() -> Unit) = skipWaitTimeForInstanceTermination(SkipWaitTimeForInstanceTerminationRequest.Builder().apply(block).build())

    /**
     * Attempts to stop an ongoing deployment.
     */
    suspend fun stopDeployment(input: StopDeploymentRequest): StopDeploymentResponse

    /**
     * Attempts to stop an ongoing deployment.
     */
    suspend fun stopDeployment(block: StopDeploymentRequest.Builder.() -> Unit) = stopDeployment(StopDeploymentRequest.Builder().apply(block).build())

    /**
     * Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Associates the list of tags in the input `Tags` parameter with the resource identified by the `ResourceArn` input parameter.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Disassociates a resource from a list of tags. The resource is identified by the `ResourceArn` input parameter. The tags are identified by the list of keys in the `TagKeys` input parameter.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

    /**
     * Changes the name of an application.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest = UpdateApplicationRequest {}): UpdateApplicationResponse

    /**
     * Changes the name of an application.
     */
    suspend fun updateApplication(block: UpdateApplicationRequest.Builder.() -> Unit) = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())

    /**
     * Changes information about a deployment group.
     */
    suspend fun updateDeploymentGroup(input: UpdateDeploymentGroupRequest): UpdateDeploymentGroupResponse

    /**
     * Changes information about a deployment group.
     */
    suspend fun updateDeploymentGroup(block: UpdateDeploymentGroupRequest.Builder.() -> Unit) = updateDeploymentGroup(UpdateDeploymentGroupRequest.Builder().apply(block).build())
}
