// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.codeconnections.auth.CodeConnectionsAuthSchemeProvider
import aws.sdk.kotlin.services.codeconnections.auth.DefaultCodeConnectionsAuthSchemeProvider
import aws.sdk.kotlin.services.codeconnections.endpoints.CodeConnectionsEndpointParameters
import aws.sdk.kotlin.services.codeconnections.endpoints.CodeConnectionsEndpointProvider
import aws.sdk.kotlin.services.codeconnections.endpoints.DefaultCodeConnectionsEndpointProvider
import aws.sdk.kotlin.services.codeconnections.model.CreateConnectionRequest
import aws.sdk.kotlin.services.codeconnections.model.CreateConnectionResponse
import aws.sdk.kotlin.services.codeconnections.model.CreateHostRequest
import aws.sdk.kotlin.services.codeconnections.model.CreateHostResponse
import aws.sdk.kotlin.services.codeconnections.model.CreateRepositoryLinkRequest
import aws.sdk.kotlin.services.codeconnections.model.CreateRepositoryLinkResponse
import aws.sdk.kotlin.services.codeconnections.model.CreateSyncConfigurationRequest
import aws.sdk.kotlin.services.codeconnections.model.CreateSyncConfigurationResponse
import aws.sdk.kotlin.services.codeconnections.model.DeleteConnectionRequest
import aws.sdk.kotlin.services.codeconnections.model.DeleteConnectionResponse
import aws.sdk.kotlin.services.codeconnections.model.DeleteHostRequest
import aws.sdk.kotlin.services.codeconnections.model.DeleteHostResponse
import aws.sdk.kotlin.services.codeconnections.model.DeleteRepositoryLinkRequest
import aws.sdk.kotlin.services.codeconnections.model.DeleteRepositoryLinkResponse
import aws.sdk.kotlin.services.codeconnections.model.DeleteSyncConfigurationRequest
import aws.sdk.kotlin.services.codeconnections.model.DeleteSyncConfigurationResponse
import aws.sdk.kotlin.services.codeconnections.model.GetConnectionRequest
import aws.sdk.kotlin.services.codeconnections.model.GetConnectionResponse
import aws.sdk.kotlin.services.codeconnections.model.GetHostRequest
import aws.sdk.kotlin.services.codeconnections.model.GetHostResponse
import aws.sdk.kotlin.services.codeconnections.model.GetRepositoryLinkRequest
import aws.sdk.kotlin.services.codeconnections.model.GetRepositoryLinkResponse
import aws.sdk.kotlin.services.codeconnections.model.GetRepositorySyncStatusRequest
import aws.sdk.kotlin.services.codeconnections.model.GetRepositorySyncStatusResponse
import aws.sdk.kotlin.services.codeconnections.model.GetResourceSyncStatusRequest
import aws.sdk.kotlin.services.codeconnections.model.GetResourceSyncStatusResponse
import aws.sdk.kotlin.services.codeconnections.model.GetSyncBlockerSummaryRequest
import aws.sdk.kotlin.services.codeconnections.model.GetSyncBlockerSummaryResponse
import aws.sdk.kotlin.services.codeconnections.model.GetSyncConfigurationRequest
import aws.sdk.kotlin.services.codeconnections.model.GetSyncConfigurationResponse
import aws.sdk.kotlin.services.codeconnections.model.ListConnectionsRequest
import aws.sdk.kotlin.services.codeconnections.model.ListConnectionsResponse
import aws.sdk.kotlin.services.codeconnections.model.ListHostsRequest
import aws.sdk.kotlin.services.codeconnections.model.ListHostsResponse
import aws.sdk.kotlin.services.codeconnections.model.ListRepositoryLinksRequest
import aws.sdk.kotlin.services.codeconnections.model.ListRepositoryLinksResponse
import aws.sdk.kotlin.services.codeconnections.model.ListRepositorySyncDefinitionsRequest
import aws.sdk.kotlin.services.codeconnections.model.ListRepositorySyncDefinitionsResponse
import aws.sdk.kotlin.services.codeconnections.model.ListSyncConfigurationsRequest
import aws.sdk.kotlin.services.codeconnections.model.ListSyncConfigurationsResponse
import aws.sdk.kotlin.services.codeconnections.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.codeconnections.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.codeconnections.model.TagResourceRequest
import aws.sdk.kotlin.services.codeconnections.model.TagResourceResponse
import aws.sdk.kotlin.services.codeconnections.model.UntagResourceRequest
import aws.sdk.kotlin.services.codeconnections.model.UntagResourceResponse
import aws.sdk.kotlin.services.codeconnections.model.UpdateHostRequest
import aws.sdk.kotlin.services.codeconnections.model.UpdateHostResponse
import aws.sdk.kotlin.services.codeconnections.model.UpdateRepositoryLinkRequest
import aws.sdk.kotlin.services.codeconnections.model.UpdateRepositoryLinkResponse
import aws.sdk.kotlin.services.codeconnections.model.UpdateSyncBlockerRequest
import aws.sdk.kotlin.services.codeconnections.model.UpdateSyncBlockerResponse
import aws.sdk.kotlin.services.codeconnections.model.UpdateSyncConfigurationRequest
import aws.sdk.kotlin.services.codeconnections.model.UpdateSyncConfigurationResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "CodeConnections"
public const val SdkVersion: String = "1.5.5"
public const val ServiceApiVersion: String = "2023-12-01"

/**
 * # AWS CodeConnections
 * This Amazon Web Services CodeConnections API Reference provides descriptions and usage examples of the operations and data types for the Amazon Web Services CodeConnections API. You can use the connections API to work with connections and installations.
 *
 * *Connections* are configurations that you use to connect Amazon Web Services resources to external code repositories. Each connection is a resource that can be given to services such as CodePipeline to connect to a third-party repository such as Bitbucket. For example, you can add the connection in CodePipeline so that it triggers your pipeline when a code change is made to your third-party code repository. Each connection is named and associated with a unique ARN that is used to reference the connection.
 *
 * When you create a connection, the console initiates a third-party connection handshake. *Installations* are the apps that are used to conduct this handshake. For example, the installation for the Bitbucket provider type is the Bitbucket app. When you create a connection, you can choose an existing installation or create one.
 *
 * When you want to create a connection to an installed provider type such as GitHub Enterprise Server, you create a *host* for your connections.
 *
 * You can work with connections by calling:
 * + CreateConnection, which creates a uniquely named connection that can be referenced by services such as CodePipeline.
 * + DeleteConnection, which deletes the specified connection.
 * + GetConnection, which returns information about the connection, including the connection status.
 * + ListConnections, which lists the connections associated with your account.
 *
 * You can work with hosts by calling:
 * + CreateHost, which creates a host that represents the infrastructure where your provider is installed.
 * + DeleteHost, which deletes the specified host.
 * + GetHost, which returns information about the host, including the setup status.
 * + ListHosts, which lists the hosts associated with your account.
 *
 * You can work with tags in Amazon Web Services CodeConnections by calling the following:
 * + ListTagsForResource, which gets information about Amazon Web Services tags for a specified Amazon Resource Name (ARN) in Amazon Web Services CodeConnections.
 * + TagResource, which adds or updates tags for a resource in Amazon Web Services CodeConnections.
 * + UntagResource, which removes tags for a resource in Amazon Web Services CodeConnections.
 *
 * For information about how to use Amazon Web Services CodeConnections, see the [Developer Tools User Guide](https://docs.aws.amazon.com/dtconsole/latest/userguide/welcome-connections.html).
 */
public interface CodeConnectionsClient : SdkClient {
    /**
     * CodeConnectionsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, CodeConnectionsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "CodeConnections",
                "CODECONNECTIONS",
                "codeconnections",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, CodeConnectionsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): CodeConnectionsClient = DefaultCodeConnectionsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: CodeConnectionsEndpointProvider = builder.endpointProvider ?: DefaultCodeConnectionsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: CodeConnectionsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultCodeConnectionsAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "CodeConnections"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: CodeConnectionsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: CodeConnectionsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
     */
    public suspend fun createConnection(input: CreateConnectionRequest): CreateConnectionResponse

    /**
     * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
     *
     * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.
     */
    public suspend fun createHost(input: CreateHostRequest): CreateHostResponse

    /**
     * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
     */
    public suspend fun createRepositoryLink(input: CreateRepositoryLinkRequest): CreateRepositoryLinkResponse

    /**
     * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
     */
    public suspend fun createSyncConfiguration(input: CreateSyncConfigurationRequest): CreateSyncConfigurationResponse

    /**
     * The connection to be deleted.
     */
    public suspend fun deleteConnection(input: DeleteConnectionRequest): DeleteConnectionResponse

    /**
     * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
     *
     * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
     */
    public suspend fun deleteHost(input: DeleteHostRequest): DeleteHostResponse

    /**
     * Deletes the association between your connection and a specified external Git repository.
     */
    public suspend fun deleteRepositoryLink(input: DeleteRepositoryLinkRequest): DeleteRepositoryLinkResponse

    /**
     * Deletes the sync configuration for a specified repository and connection.
     */
    public suspend fun deleteSyncConfiguration(input: DeleteSyncConfigurationRequest): DeleteSyncConfigurationResponse

    /**
     * Returns the connection ARN and details such as status, owner, and provider type.
     */
    public suspend fun getConnection(input: GetConnectionRequest): GetConnectionResponse

    /**
     * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
     */
    public suspend fun getHost(input: GetHostRequest): GetHostResponse

    /**
     * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files in a specified Git repository.
     */
    public suspend fun getRepositoryLink(input: GetRepositoryLinkRequest): GetRepositoryLinkResponse

    /**
     * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes from your remote repository.
     */
    public suspend fun getRepositorySyncStatus(input: GetRepositorySyncStatusRequest): GetRepositorySyncStatusResponse

    /**
     * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
     */
    public suspend fun getResourceSyncStatus(input: GetResourceSyncStatusRequest): GetResourceSyncStatusResponse

    /**
     * Returns a list of the most recent sync blockers.
     */
    public suspend fun getSyncBlockerSummary(input: GetSyncBlockerSummaryRequest): GetSyncBlockerSummaryResponse

    /**
     * Returns details about a sync configuration, including the sync type and resource name. A sync configuration allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a Git repository.
     */
    public suspend fun getSyncConfiguration(input: GetSyncConfigurationRequest): GetSyncConfigurationResponse

    /**
     * Lists the connections associated with your account.
     */
    public suspend fun listConnections(input: ListConnectionsRequest = ListConnectionsRequest { }): ListConnectionsResponse

    /**
     * Lists the hosts associated with your account.
     */
    public suspend fun listHosts(input: ListHostsRequest = ListHostsRequest { }): ListHostsResponse

    /**
     * Lists the repository links created for connections in your account.
     */
    public suspend fun listRepositoryLinks(input: ListRepositoryLinksRequest = ListRepositoryLinksRequest { }): ListRepositoryLinksResponse

    /**
     * Lists the repository sync definitions for repository links in your account.
     */
    public suspend fun listRepositorySyncDefinitions(input: ListRepositorySyncDefinitionsRequest): ListRepositorySyncDefinitionsResponse

    /**
     * Returns a list of sync configurations for a specified repository.
     */
    public suspend fun listSyncConfigurations(input: ListSyncConfigurationsRequest): ListSyncConfigurationsResponse

    /**
     * Gets the set of key-value pairs (metadata) that are used to manage the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from an Amazon Web Services resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a specified host with the provided configurations.
     */
    public suspend fun updateHost(input: UpdateHostRequest): UpdateHostResponse

    /**
     * Updates the association between your connection and a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
     */
    public suspend fun updateRepositoryLink(input: UpdateRepositoryLinkRequest): UpdateRepositoryLinkResponse

    /**
     * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
     */
    public suspend fun updateSyncBlocker(input: UpdateSyncBlockerRequest): UpdateSyncBlockerResponse

    /**
     * Updates the sync configuration for your connection and a specified external Git repository.
     */
    public suspend fun updateSyncConfiguration(input: UpdateSyncConfigurationRequest): UpdateSyncConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun CodeConnectionsClient.withConfig(block: CodeConnectionsClient.Config.Builder.() -> Unit): CodeConnectionsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultCodeConnectionsClient(newConfig)
}

/**
 * Creates a connection that can then be given to other Amazon Web Services services like CodePipeline so that it can access third-party code repositories. The connection is in pending status until the third-party connection handshake is completed from the console.
 */
public suspend inline fun CodeConnectionsClient.createConnection(crossinline block: CreateConnectionRequest.Builder.() -> Unit): CreateConnectionResponse = createConnection(CreateConnectionRequest.Builder().apply(block).build())

/**
 * Creates a resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
 *
 * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.
 */
public suspend inline fun CodeConnectionsClient.createHost(crossinline block: CreateHostRequest.Builder.() -> Unit): CreateHostResponse = createHost(CreateHostRequest.Builder().apply(block).build())

/**
 * Creates a link to a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
 */
public suspend inline fun CodeConnectionsClient.createRepositoryLink(crossinline block: CreateRepositoryLinkRequest.Builder.() -> Unit): CreateRepositoryLinkResponse = createRepositoryLink(CreateRepositoryLinkRequest.Builder().apply(block).build())

/**
 * Creates a sync configuration which allows Amazon Web Services to sync content from a Git repository to update a specified Amazon Web Services resource. Parameters for the sync configuration are determined by the sync type.
 */
public suspend inline fun CodeConnectionsClient.createSyncConfiguration(crossinline block: CreateSyncConfigurationRequest.Builder.() -> Unit): CreateSyncConfigurationResponse = createSyncConfiguration(CreateSyncConfigurationRequest.Builder().apply(block).build())

/**
 * The connection to be deleted.
 */
public suspend inline fun CodeConnectionsClient.deleteConnection(crossinline block: DeleteConnectionRequest.Builder.() -> Unit): DeleteConnectionResponse = deleteConnection(DeleteConnectionRequest.Builder().apply(block).build())

/**
 * The host to be deleted. Before you delete a host, all connections associated to the host must be deleted.
 *
 * A host cannot be deleted if it is in the VPC_CONFIG_INITIALIZING or VPC_CONFIG_DELETING state.
 */
public suspend inline fun CodeConnectionsClient.deleteHost(crossinline block: DeleteHostRequest.Builder.() -> Unit): DeleteHostResponse = deleteHost(DeleteHostRequest.Builder().apply(block).build())

/**
 * Deletes the association between your connection and a specified external Git repository.
 */
public suspend inline fun CodeConnectionsClient.deleteRepositoryLink(crossinline block: DeleteRepositoryLinkRequest.Builder.() -> Unit): DeleteRepositoryLinkResponse = deleteRepositoryLink(DeleteRepositoryLinkRequest.Builder().apply(block).build())

/**
 * Deletes the sync configuration for a specified repository and connection.
 */
public suspend inline fun CodeConnectionsClient.deleteSyncConfiguration(crossinline block: DeleteSyncConfigurationRequest.Builder.() -> Unit): DeleteSyncConfigurationResponse = deleteSyncConfiguration(DeleteSyncConfigurationRequest.Builder().apply(block).build())

/**
 * Returns the connection ARN and details such as status, owner, and provider type.
 */
public suspend inline fun CodeConnectionsClient.getConnection(crossinline block: GetConnectionRequest.Builder.() -> Unit): GetConnectionResponse = getConnection(GetConnectionRequest.Builder().apply(block).build())

/**
 * Returns the host ARN and details such as status, provider type, endpoint, and, if applicable, the VPC configuration.
 */
public suspend inline fun CodeConnectionsClient.getHost(crossinline block: GetHostRequest.Builder.() -> Unit): GetHostResponse = getHost(GetHostRequest.Builder().apply(block).build())

/**
 * Returns details about a repository link. A repository link allows Git sync to monitor and sync changes from files in a specified Git repository.
 */
public suspend inline fun CodeConnectionsClient.getRepositoryLink(crossinline block: GetRepositoryLinkRequest.Builder.() -> Unit): GetRepositoryLinkResponse = getRepositoryLink(GetRepositoryLinkRequest.Builder().apply(block).build())

/**
 * Returns details about the sync status for a repository. A repository sync uses Git sync to push and pull changes from your remote repository.
 */
public suspend inline fun CodeConnectionsClient.getRepositorySyncStatus(crossinline block: GetRepositorySyncStatusRequest.Builder.() -> Unit): GetRepositorySyncStatusResponse = getRepositorySyncStatus(GetRepositorySyncStatusRequest.Builder().apply(block).build())

/**
 * Returns the status of the sync with the Git repository for a specific Amazon Web Services resource.
 */
public suspend inline fun CodeConnectionsClient.getResourceSyncStatus(crossinline block: GetResourceSyncStatusRequest.Builder.() -> Unit): GetResourceSyncStatusResponse = getResourceSyncStatus(GetResourceSyncStatusRequest.Builder().apply(block).build())

/**
 * Returns a list of the most recent sync blockers.
 */
public suspend inline fun CodeConnectionsClient.getSyncBlockerSummary(crossinline block: GetSyncBlockerSummaryRequest.Builder.() -> Unit): GetSyncBlockerSummaryResponse = getSyncBlockerSummary(GetSyncBlockerSummaryRequest.Builder().apply(block).build())

/**
 * Returns details about a sync configuration, including the sync type and resource name. A sync configuration allows the configuration to sync (push and pull) changes from the remote repository for a specified branch in a Git repository.
 */
public suspend inline fun CodeConnectionsClient.getSyncConfiguration(crossinline block: GetSyncConfigurationRequest.Builder.() -> Unit): GetSyncConfigurationResponse = getSyncConfiguration(GetSyncConfigurationRequest.Builder().apply(block).build())

/**
 * Lists the connections associated with your account.
 */
public suspend inline fun CodeConnectionsClient.listConnections(crossinline block: ListConnectionsRequest.Builder.() -> Unit): ListConnectionsResponse = listConnections(ListConnectionsRequest.Builder().apply(block).build())

/**
 * Lists the hosts associated with your account.
 */
public suspend inline fun CodeConnectionsClient.listHosts(crossinline block: ListHostsRequest.Builder.() -> Unit): ListHostsResponse = listHosts(ListHostsRequest.Builder().apply(block).build())

/**
 * Lists the repository links created for connections in your account.
 */
public suspend inline fun CodeConnectionsClient.listRepositoryLinks(crossinline block: ListRepositoryLinksRequest.Builder.() -> Unit): ListRepositoryLinksResponse = listRepositoryLinks(ListRepositoryLinksRequest.Builder().apply(block).build())

/**
 * Lists the repository sync definitions for repository links in your account.
 */
public suspend inline fun CodeConnectionsClient.listRepositorySyncDefinitions(crossinline block: ListRepositorySyncDefinitionsRequest.Builder.() -> Unit): ListRepositorySyncDefinitionsResponse = listRepositorySyncDefinitions(ListRepositorySyncDefinitionsRequest.Builder().apply(block).build())

/**
 * Returns a list of sync configurations for a specified repository.
 */
public suspend inline fun CodeConnectionsClient.listSyncConfigurations(crossinline block: ListSyncConfigurationsRequest.Builder.() -> Unit): ListSyncConfigurationsResponse = listSyncConfigurations(ListSyncConfigurationsRequest.Builder().apply(block).build())

/**
 * Gets the set of key-value pairs (metadata) that are used to manage the resource.
 */
public suspend inline fun CodeConnectionsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata that can be used to manage a resource.
 */
public suspend inline fun CodeConnectionsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from an Amazon Web Services resource.
 */
public suspend inline fun CodeConnectionsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a specified host with the provided configurations.
 */
public suspend inline fun CodeConnectionsClient.updateHost(crossinline block: UpdateHostRequest.Builder.() -> Unit): UpdateHostResponse = updateHost(UpdateHostRequest.Builder().apply(block).build())

/**
 * Updates the association between your connection and a specified external Git repository. A repository link allows Git sync to monitor and sync changes to files in a specified Git repository.
 */
public suspend inline fun CodeConnectionsClient.updateRepositoryLink(crossinline block: UpdateRepositoryLinkRequest.Builder.() -> Unit): UpdateRepositoryLinkResponse = updateRepositoryLink(UpdateRepositoryLinkRequest.Builder().apply(block).build())

/**
 * Allows you to update the status of a sync blocker, resolving the blocker and allowing syncing to continue.
 */
public suspend inline fun CodeConnectionsClient.updateSyncBlocker(crossinline block: UpdateSyncBlockerRequest.Builder.() -> Unit): UpdateSyncBlockerResponse = updateSyncBlocker(UpdateSyncBlockerRequest.Builder().apply(block).build())

/**
 * Updates the sync configuration for your connection and a specified external Git repository.
 */
public suspend inline fun CodeConnectionsClient.updateSyncConfiguration(crossinline block: UpdateSyncConfigurationRequest.Builder.() -> Unit): UpdateSyncConfigurationResponse = updateSyncConfiguration(UpdateSyncConfigurationRequest.Builder().apply(block).build())
