// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections.serde

import aws.sdk.kotlin.services.codeconnections.model.CodeConnectionsException
import aws.sdk.kotlin.services.codeconnections.model.SyncBlocker
import aws.sdk.kotlin.services.codeconnections.model.UpdateSyncBlockerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateSyncBlockerOperationDeserializer: HttpDeserializer.NonStreaming<UpdateSyncBlockerResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateSyncBlockerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSyncBlockerError(context, call, payload)
        }
        val builder = UpdateSyncBlockerResponse.Builder()

        if (payload != null) {
            deserializeUpdateSyncBlockerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateSyncBlockerError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeConnectionsException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SyncBlockerDoesNotExistException" -> SyncBlockerDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInputException" -> InvalidInputExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RetryLatestCommitFailedException" -> RetryLatestCommitFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeConnectionsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSyncBlockerOperationBody(builder: UpdateSyncBlockerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PARENTRESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParentResourceName"))
    val RESOURCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceName"))
    val SYNCBLOCKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("SyncBlocker"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PARENTRESOURCENAME_DESCRIPTOR)
        field(RESOURCENAME_DESCRIPTOR)
        field(SYNCBLOCKER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PARENTRESOURCENAME_DESCRIPTOR.index -> builder.parentResourceName = deserializeString()
                RESOURCENAME_DESCRIPTOR.index -> builder.resourceName = deserializeString()
                SYNCBLOCKER_DESCRIPTOR.index -> builder.syncBlocker = deserializeSyncBlockerDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
