// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a blocker for a sync event.
 */
public class SyncBlocker private constructor(builder: Builder) {
    /**
     * The contexts for a specific sync blocker.
     */
    public val contexts: List<SyncBlockerContext>? = builder.contexts
    /**
     * The creation time for a specific sync blocker.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The provided reason for a specific sync blocker.
     */
    public val createdReason: kotlin.String = requireNotNull(builder.createdReason) { "A non-null value must be provided for createdReason" }
    /**
     * The ID for a specific sync blocker.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The time that a specific sync blocker was resolved.
     */
    public val resolvedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.resolvedAt
    /**
     * The resolved reason for a specific sync blocker.
     */
    public val resolvedReason: kotlin.String? = builder.resolvedReason
    /**
     * The status for a specific sync blocker.
     */
    public val status: aws.sdk.kotlin.services.codeconnections.model.BlockerStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The sync blocker type.
     */
    public val type: aws.sdk.kotlin.services.codeconnections.model.BlockerType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeconnections.model.SyncBlocker = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SyncBlocker(")
        append("contexts=$contexts,")
        append("createdAt=$createdAt,")
        append("createdReason=$createdReason,")
        append("id=$id,")
        append("resolvedAt=$resolvedAt,")
        append("resolvedReason=$resolvedReason,")
        append("status=$status,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contexts?.hashCode() ?: 0
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (createdReason.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (resolvedAt?.hashCode() ?: 0)
        result = 31 * result + (resolvedReason?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SyncBlocker

        if (contexts != other.contexts) return false
        if (createdAt != other.createdAt) return false
        if (createdReason != other.createdReason) return false
        if (id != other.id) return false
        if (resolvedAt != other.resolvedAt) return false
        if (resolvedReason != other.resolvedReason) return false
        if (status != other.status) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeconnections.model.SyncBlocker = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The contexts for a specific sync blocker.
         */
        public var contexts: List<SyncBlockerContext>? = null
        /**
         * The creation time for a specific sync blocker.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The provided reason for a specific sync blocker.
         */
        public var createdReason: kotlin.String? = null
        /**
         * The ID for a specific sync blocker.
         */
        public var id: kotlin.String? = null
        /**
         * The time that a specific sync blocker was resolved.
         */
        public var resolvedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resolved reason for a specific sync blocker.
         */
        public var resolvedReason: kotlin.String? = null
        /**
         * The status for a specific sync blocker.
         */
        public var status: aws.sdk.kotlin.services.codeconnections.model.BlockerStatus? = null
        /**
         * The sync blocker type.
         */
        public var type: aws.sdk.kotlin.services.codeconnections.model.BlockerType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeconnections.model.SyncBlocker) : this() {
            this.contexts = x.contexts
            this.createdAt = x.createdAt
            this.createdReason = x.createdReason
            this.id = x.id
            this.resolvedAt = x.resolvedAt
            this.resolvedReason = x.resolvedReason
            this.status = x.status
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeconnections.model.SyncBlocker = SyncBlocker(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (createdReason == null) createdReason = ""
            if (id == null) id = ""
            if (status == null) status = BlockerStatus.SdkUnknown("no value provided")
            if (type == null) type = BlockerType.SdkUnknown("no value provided")
            return this
        }
    }
}
