// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a resource sync attempt.
 */
public class ResourceSyncAttempt private constructor(builder: Builder) {
    /**
     * The events related to a resource sync attempt.
     */
    public val events: List<ResourceSyncEvent> = requireNotNull(builder.events) { "A non-null value must be provided for events" }
    /**
     * The current state of the resource as defined in the resource's `config-file` in the linked repository.
     */
    public val initialRevision: aws.sdk.kotlin.services.codeconnections.model.Revision? = builder.initialRevision
    /**
     * The start time for a resource sync attempt.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedAt) { "A non-null value must be provided for startedAt" }
    /**
     * The status for a resource sync attempt. The follow are valid statuses:
     * + SYNC-INITIATED - A resource sync attempt has been created and will begin soon.
     * + SYNCING - Syncing has started and work is being done to reconcile state.
     * + SYNCED - Syncing has completed successfully.
     * + SYNC_FAILED - A resource sync attempt has failed.
     */
    public val status: aws.sdk.kotlin.services.codeconnections.model.ResourceSyncStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The name of the Amazon Web Services resource that is attempted to be synchronized.
     */
    public val target: kotlin.String = requireNotNull(builder.target) { "A non-null value must be provided for target" }
    /**
     * The desired state of the resource as defined in the resource's `config-file` in the linked repository. Git sync attempts to update the resource to this state.
     */
    public val targetRevision: aws.sdk.kotlin.services.codeconnections.model.Revision? = builder.targetRevision

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeconnections.model.ResourceSyncAttempt = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceSyncAttempt(")
        append("events=$events,")
        append("initialRevision=$initialRevision,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("target=$target,")
        append("targetRevision=$targetRevision")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = events.hashCode()
        result = 31 * result + (initialRevision?.hashCode() ?: 0)
        result = 31 * result + (startedAt.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (target.hashCode())
        result = 31 * result + (targetRevision?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceSyncAttempt

        if (events != other.events) return false
        if (initialRevision != other.initialRevision) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (target != other.target) return false
        if (targetRevision != other.targetRevision) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeconnections.model.ResourceSyncAttempt = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The events related to a resource sync attempt.
         */
        public var events: List<ResourceSyncEvent>? = null
        /**
         * The current state of the resource as defined in the resource's `config-file` in the linked repository.
         */
        public var initialRevision: aws.sdk.kotlin.services.codeconnections.model.Revision? = null
        /**
         * The start time for a resource sync attempt.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status for a resource sync attempt. The follow are valid statuses:
         * + SYNC-INITIATED - A resource sync attempt has been created and will begin soon.
         * + SYNCING - Syncing has started and work is being done to reconcile state.
         * + SYNCED - Syncing has completed successfully.
         * + SYNC_FAILED - A resource sync attempt has failed.
         */
        public var status: aws.sdk.kotlin.services.codeconnections.model.ResourceSyncStatus? = null
        /**
         * The name of the Amazon Web Services resource that is attempted to be synchronized.
         */
        public var target: kotlin.String? = null
        /**
         * The desired state of the resource as defined in the resource's `config-file` in the linked repository. Git sync attempts to update the resource to this state.
         */
        public var targetRevision: aws.sdk.kotlin.services.codeconnections.model.Revision? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeconnections.model.ResourceSyncAttempt) : this() {
            this.events = x.events
            this.initialRevision = x.initialRevision
            this.startedAt = x.startedAt
            this.status = x.status
            this.target = x.target
            this.targetRevision = x.targetRevision
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeconnections.model.ResourceSyncAttempt = ResourceSyncAttempt(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeconnections.model.Revision] inside the given [block]
         */
        public fun initialRevision(block: aws.sdk.kotlin.services.codeconnections.model.Revision.Builder.() -> kotlin.Unit) {
            this.initialRevision = aws.sdk.kotlin.services.codeconnections.model.Revision.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.codeconnections.model.Revision] inside the given [block]
         */
        public fun targetRevision(block: aws.sdk.kotlin.services.codeconnections.model.Revision.Builder.() -> kotlin.Unit) {
            this.targetRevision = aws.sdk.kotlin.services.codeconnections.model.Revision.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (events == null) events = emptyList()
            if (startedAt == null) startedAt = Instant.fromEpochSeconds(0)
            if (status == null) status = ResourceSyncStatus.SdkUnknown("no value provided")
            if (target == null) target = ""
            return this
        }
    }
}
