// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections.model



/**
 * Information about the repository link resource, such as the repository link ARN, the associated connection ARN, encryption key ARN, and owner ID.
 */
public class RepositoryLinkInfo private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the connection associated with the repository link.
     */
    public val connectionArn: kotlin.String = requireNotNull(builder.connectionArn) { "A non-null value must be provided for connectionArn" }
    /**
     * The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository link.
     */
    public val encryptionKeyArn: kotlin.String? = builder.encryptionKeyArn
    /**
     * The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
     */
    public val ownerId: kotlin.String = requireNotNull(builder.ownerId) { "A non-null value must be provided for ownerId" }
    /**
     * The provider type for the connection, such as GitHub, associated with the repository link.
     */
    public val providerType: aws.sdk.kotlin.services.codeconnections.model.ProviderType = requireNotNull(builder.providerType) { "A non-null value must be provided for providerType" }
    /**
     * The Amazon Resource Name (ARN) of the repository link.
     */
    public val repositoryLinkArn: kotlin.String = requireNotNull(builder.repositoryLinkArn) { "A non-null value must be provided for repositoryLinkArn" }
    /**
     * The ID of the repository link.
     */
    public val repositoryLinkId: kotlin.String = requireNotNull(builder.repositoryLinkId) { "A non-null value must be provided for repositoryLinkId" }
    /**
     * The name of the repository associated with the repository link.
     */
    public val repositoryName: kotlin.String = requireNotNull(builder.repositoryName) { "A non-null value must be provided for repositoryName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeconnections.model.RepositoryLinkInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryLinkInfo(")
        append("connectionArn=$connectionArn,")
        append("encryptionKeyArn=$encryptionKeyArn,")
        append("ownerId=$ownerId,")
        append("providerType=$providerType,")
        append("repositoryLinkArn=$repositoryLinkArn,")
        append("repositoryLinkId=$repositoryLinkId,")
        append("repositoryName=$repositoryName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectionArn.hashCode()
        result = 31 * result + (encryptionKeyArn?.hashCode() ?: 0)
        result = 31 * result + (ownerId.hashCode())
        result = 31 * result + (providerType.hashCode())
        result = 31 * result + (repositoryLinkArn.hashCode())
        result = 31 * result + (repositoryLinkId.hashCode())
        result = 31 * result + (repositoryName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryLinkInfo

        if (connectionArn != other.connectionArn) return false
        if (encryptionKeyArn != other.encryptionKeyArn) return false
        if (ownerId != other.ownerId) return false
        if (providerType != other.providerType) return false
        if (repositoryLinkArn != other.repositoryLinkArn) return false
        if (repositoryLinkId != other.repositoryLinkId) return false
        if (repositoryName != other.repositoryName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeconnections.model.RepositoryLinkInfo = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the connection associated with the repository link.
         */
        public var connectionArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the encryption key for the repository associated with the repository link.
         */
        public var encryptionKeyArn: kotlin.String? = null
        /**
         * The owner ID for the repository associated with the repository link, such as the owner ID in GitHub.
         */
        public var ownerId: kotlin.String? = null
        /**
         * The provider type for the connection, such as GitHub, associated with the repository link.
         */
        public var providerType: aws.sdk.kotlin.services.codeconnections.model.ProviderType? = null
        /**
         * The Amazon Resource Name (ARN) of the repository link.
         */
        public var repositoryLinkArn: kotlin.String? = null
        /**
         * The ID of the repository link.
         */
        public var repositoryLinkId: kotlin.String? = null
        /**
         * The name of the repository associated with the repository link.
         */
        public var repositoryName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeconnections.model.RepositoryLinkInfo) : this() {
            this.connectionArn = x.connectionArn
            this.encryptionKeyArn = x.encryptionKeyArn
            this.ownerId = x.ownerId
            this.providerType = x.providerType
            this.repositoryLinkArn = x.repositoryLinkArn
            this.repositoryLinkId = x.repositoryLinkId
            this.repositoryName = x.repositoryName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeconnections.model.RepositoryLinkInfo = RepositoryLinkInfo(this)

        internal fun correctErrors(): Builder {
            if (connectionArn == null) connectionArn = ""
            if (ownerId == null) ownerId = ""
            if (providerType == null) providerType = ProviderType.SdkUnknown("no value provided")
            if (repositoryLinkArn == null) repositoryLinkArn = ""
            if (repositoryLinkId == null) repositoryLinkId = ""
            if (repositoryName == null) repositoryName = ""
            return this
        }
    }
}
