// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codeconnections.model



/**
 * A resource that represents the infrastructure where a third-party provider is installed. The host is used when you create connections to an installed third-party provider type, such as GitHub Enterprise Server. You create one host for all connections to that provider.
 *
 * A host created through the CLI or the SDK is in `PENDING` status by default. You can make its status `AVAILABLE` by setting up the host in the console.
 */
public class Host private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the host.
     */
    public val hostArn: kotlin.String? = builder.hostArn
    /**
     * The name of the host.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The endpoint of the infrastructure where your provider type is installed.
     */
    public val providerEndpoint: kotlin.String? = builder.providerEndpoint
    /**
     * The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.
     */
    public val providerType: aws.sdk.kotlin.services.codeconnections.model.ProviderType? = builder.providerType
    /**
     * The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING, VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The status description for the host.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The VPC configuration provisioned for the host.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.codeconnections.model.VpcConfiguration? = builder.vpcConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.codeconnections.model.Host = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Host(")
        append("hostArn=$hostArn,")
        append("name=$name,")
        append("providerEndpoint=$providerEndpoint,")
        append("providerType=$providerType,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("vpcConfiguration=$vpcConfiguration")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = hostArn?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (providerEndpoint?.hashCode() ?: 0)
        result = 31 * result + (providerType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Host

        if (hostArn != other.hostArn) return false
        if (name != other.name) return false
        if (providerEndpoint != other.providerEndpoint) return false
        if (providerType != other.providerType) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (vpcConfiguration != other.vpcConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.codeconnections.model.Host = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the host.
         */
        public var hostArn: kotlin.String? = null
        /**
         * The name of the host.
         */
        public var name: kotlin.String? = null
        /**
         * The endpoint of the infrastructure where your provider type is installed.
         */
        public var providerEndpoint: kotlin.String? = null
        /**
         * The name of the installed provider to be associated with your connection. The host resource represents the infrastructure where your provider type is installed. The valid provider type is GitHub Enterprise Server.
         */
        public var providerType: aws.sdk.kotlin.services.codeconnections.model.ProviderType? = null
        /**
         * The status of the host, such as PENDING, AVAILABLE, VPC_CONFIG_DELETING, VPC_CONFIG_INITIALIZING, and VPC_CONFIG_FAILED_INITIALIZATION.
         */
        public var status: kotlin.String? = null
        /**
         * The status description for the host.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The VPC configuration provisioned for the host.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.codeconnections.model.VpcConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.codeconnections.model.Host) : this() {
            this.hostArn = x.hostArn
            this.name = x.name
            this.providerEndpoint = x.providerEndpoint
            this.providerType = x.providerType
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.vpcConfiguration = x.vpcConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.codeconnections.model.Host = Host(this)

        /**
         * construct an [aws.sdk.kotlin.services.codeconnections.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.codeconnections.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.codeconnections.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
