// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.PullRequest
import aws.sdk.kotlin.services.codecommit.model.UpdatePullRequestDescriptionResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdatePullRequestDescriptionOperationDeserializer: HttpDeserializer.NonStreaming<UpdatePullRequestDescriptionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdatePullRequestDescriptionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePullRequestDescriptionError(context, call, payload)
        }
        val builder = UpdatePullRequestDescriptionResponse.Builder()

        if (payload != null) {
            deserializeUpdatePullRequestDescriptionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdatePullRequestDescriptionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidPullRequestIdException" -> InvalidPullRequestIdExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestAlreadyClosedException" -> PullRequestAlreadyClosedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestDoesNotExistException" -> PullRequestDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PullRequestIdRequiredException" -> PullRequestIdRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDescriptionException" -> InvalidDescriptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePullRequestDescriptionOperationBody(builder: UpdatePullRequestDescriptionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PULLREQUEST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("pullRequest"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PULLREQUEST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PULLREQUEST_DESCRIPTOR.index -> builder.pullRequest = deserializePullRequestDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
