// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.RepositoryTriggerExecutionFailure
import aws.sdk.kotlin.services.codecommit.model.TestRepositoryTriggersResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class TestRepositoryTriggersOperationDeserializer: HttpDeserializer.NonStreaming<TestRepositoryTriggersResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): TestRepositoryTriggersResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwTestRepositoryTriggersError(context, call, payload)
        }
        val builder = TestRepositoryTriggersResponse.Builder()

        if (payload != null) {
            deserializeTestRepositoryTriggersOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwTestRepositoryTriggersError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerBranchNameException" -> InvalidRepositoryTriggerBranchNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumBranchesExceededException" -> MaximumBranchesExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerCustomDataException" -> InvalidRepositoryTriggerCustomDataExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerNameException" -> InvalidRepositoryTriggerNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryTriggersListRequiredException" -> RepositoryTriggersListRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryTriggerNameRequiredException" -> RepositoryTriggerNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryTriggerBranchNameListRequiredException" -> RepositoryTriggerBranchNameListRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryTriggerEventsListRequiredException" -> RepositoryTriggerEventsListRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerDestinationArnException" -> InvalidRepositoryTriggerDestinationArnExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerEventsException" -> InvalidRepositoryTriggerEventsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryTriggerDestinationArnRequiredException" -> RepositoryTriggerDestinationArnRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryTriggerRegionException" -> InvalidRepositoryTriggerRegionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumRepositoryTriggersExceededException" -> MaximumRepositoryTriggersExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestRepositoryTriggersOperationBody(builder: TestRepositoryTriggersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILEDEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedExecutions"))
    val SUCCESSFULEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successfulExecutions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILEDEXECUTIONS_DESCRIPTOR)
        field(SUCCESSFULEXECUTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILEDEXECUTIONS_DESCRIPTOR.index -> builder.failedExecutions =
                    deserializer.deserializeList(FAILEDEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<RepositoryTriggerExecutionFailure>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRepositoryTriggerExecutionFailureDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFULEXECUTIONS_DESCRIPTOR.index -> builder.successfulExecutions =
                    deserializer.deserializeList(SUCCESSFULEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
