// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.MergeBranchesBySquashResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class MergeBranchesBySquashOperationDeserializer: HttpDeserializer.NonStreaming<MergeBranchesBySquashResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): MergeBranchesBySquashResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwMergeBranchesBySquashError(context, call, payload)
        }
        val builder = MergeBranchesBySquashResponse.Builder()

        if (payload != null) {
            deserializeMergeBranchesBySquashOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwMergeBranchesBySquashError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumConflictResolutionEntriesExceededException" -> MaximumConflictResolutionEntriesExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FolderContentSizeLimitExceededException" -> FolderContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplacementTypeException" -> InvalidReplacementTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConcurrentReferenceUpdateException" -> ConcurrentReferenceUpdateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ManualMergeRequiredException" -> ManualMergeRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchNameIsTagNameException" -> BranchNameIsTagNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidReplacementContentException" -> InvalidReplacementContentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReplacementTypeRequiredException" -> ReplacementTypeRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidBranchNameException" -> InvalidBranchNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileContentSizeLimitExceededException" -> FileContentSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "NameLengthExceededException" -> NameLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchNameRequiredException" -> BranchNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MultipleConflictResolutionEntriesException" -> MultipleConflictResolutionEntriesExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "BranchDoesNotExistException" -> BranchDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitMessageLengthExceededException" -> CommitMessageLengthExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ReplacementContentRequiredException" -> ReplacementContentRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictResolutionException" -> InvalidConflictResolutionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidFileModeException" -> InvalidFileModeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidEmailException" -> InvalidEmailExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTargetBranchException" -> InvalidTargetBranchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileModeRequiredException" -> FileModeRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeMergeBranchesBySquashOperationBody(builder: MergeBranchesBySquashResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val TREEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("treeId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(TREEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMITID_DESCRIPTOR.index -> builder.commitId = deserializeString()
                TREEID_DESCRIPTOR.index -> builder.treeId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
