// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.GetMergeCommitResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetMergeCommitOperationDeserializer: HttpDeserializer.NonStreaming<GetMergeCommitResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMergeCommitResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMergeCommitError(context, call, payload)
        }
        val builder = GetMergeCommitResponse.Builder()

        if (payload != null) {
            deserializeGetMergeCommitOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMergeCommitError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMergeCommitOperationBody(builder: GetMergeCommitResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseCommitId"))
    val DESTINATIONCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationCommitId"))
    val MERGEDCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("mergedCommitId"))
    val SOURCECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCommitId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASECOMMITID_DESCRIPTOR)
        field(DESTINATIONCOMMITID_DESCRIPTOR)
        field(MERGEDCOMMITID_DESCRIPTOR)
        field(SOURCECOMMITID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASECOMMITID_DESCRIPTOR.index -> builder.baseCommitId = deserializeString()
                DESTINATIONCOMMITID_DESCRIPTOR.index -> builder.destinationCommitId = deserializeString()
                MERGEDCOMMITID_DESCRIPTOR.index -> builder.mergedCommitId = deserializeString()
                SOURCECOMMITID_DESCRIPTOR.index -> builder.sourceCommitId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
