// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.codecommit.serde

import aws.sdk.kotlin.services.codecommit.model.CodeCommitException
import aws.sdk.kotlin.services.codecommit.model.ConflictMetadata
import aws.sdk.kotlin.services.codecommit.model.DescribeMergeConflictsResponse
import aws.sdk.kotlin.services.codecommit.model.MergeHunk
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeMergeConflictsOperationDeserializer: HttpDeserializer.NonStreaming<DescribeMergeConflictsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeMergeConflictsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeMergeConflictsError(context, call, payload)
        }
        val builder = DescribeMergeConflictsResponse.Builder()

        if (payload != null) {
            deserializeDescribeMergeConflictsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeMergeConflictsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw CodeCommitException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "MaximumItemsToCompareExceededException" -> MaximumItemsToCompareExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "FileDoesNotExistException" -> FileDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionIntegrityChecksFailedException" -> EncryptionIntegrityChecksFailedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyAccessDeniedException" -> EncryptionKeyAccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MergeOptionRequiredException" -> MergeOptionRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMergeOptionException" -> InvalidMergeOptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidCommitException" -> InvalidCommitExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryNameRequiredException" -> RepositoryNameRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PathRequiredException" -> PathRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyUnavailableException" -> EncryptionKeyUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidContinuationTokenException" -> InvalidContinuationTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MaximumFileContentToLoadExceededException" -> MaximumFileContentToLoadExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyNotFoundException" -> EncryptionKeyNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidMaxMergeHunksException" -> InvalidMaxMergeHunksExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRepositoryNameException" -> InvalidRepositoryNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictResolutionStrategyException" -> InvalidConflictResolutionStrategyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TipsDivergenceExceededException" -> TipsDivergenceExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitRequiredException" -> CommitRequiredExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EncryptionKeyDisabledException" -> EncryptionKeyDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "CommitDoesNotExistException" -> CommitDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidConflictDetailLevelException" -> InvalidConflictDetailLevelExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPathException" -> InvalidPathExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RepositoryDoesNotExistException" -> RepositoryDoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> CodeCommitException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMergeConflictsOperationBody(builder: DescribeMergeConflictsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("baseCommitId"))
    val CONFLICTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conflictMetadata"))
    val DESTINATIONCOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationCommitId"))
    val MERGEHUNKS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("mergeHunks"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val SOURCECOMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceCommitId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASECOMMITID_DESCRIPTOR)
        field(CONFLICTMETADATA_DESCRIPTOR)
        field(DESTINATIONCOMMITID_DESCRIPTOR)
        field(MERGEHUNKS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SOURCECOMMITID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASECOMMITID_DESCRIPTOR.index -> builder.baseCommitId = deserializeString()
                CONFLICTMETADATA_DESCRIPTOR.index -> builder.conflictMetadata = deserializeConflictMetadataDocument(deserializer)
                DESTINATIONCOMMITID_DESCRIPTOR.index -> builder.destinationCommitId = deserializeString()
                MERGEHUNKS_DESCRIPTOR.index -> builder.mergeHunks =
                    deserializer.deserializeList(MERGEHUNKS_DESCRIPTOR) {
                        val col0 = mutableListOf<MergeHunk>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMergeHunkDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SOURCECOMMITID_DESCRIPTOR.index -> builder.sourceCommitId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
